/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class LanceArrowUtils$ {
    public static final LanceArrowUtils$ MODULE$ = new LanceArrowUtils$();
    private static final String ARROW_FIXED_SIZE_LIST_SIZE_KEY = "arrow.fixed-size-list.size";

    public String ARROW_FIXED_SIZE_LIST_SIZE_KEY() {
        return ARROW_FIXED_SIZE_LIST_SIZE_KEY;
    }

    public DataType fromArrowField(Field field) {
        ArrowType.Int intVal;
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Int && !(intVal = (ArrowType.Int)arrowType).getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FixedSizeList) {
            java.util.List children = field.getChildren();
            if (children.isEmpty()) {
                throw new SparkException(new StringBuilder(36).append("FixedSizeList field ").append(field.getName()).append(" has no children").toString());
            }
            Field elementField = (Field)children.get(0);
            DataType elementType = this.fromArrowField(elementField);
            boolean containsNull = elementField.isNullable();
            return new ArrayType(elementType, containsNull);
        }
        return ArrowUtils$.MODULE$.fromArrowField(field);
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            Metadata metadata;
            DataType dt = MODULE$.fromArrowField((Field)field);
            ArrowType arrowType = field.getType();
            if (arrowType instanceof ArrowType.FixedSizeList) {
                ArrowType.FixedSizeList fixedSizeList = (ArrowType.FixedSizeList)arrowType;
                metadata = new MetadataBuilder().putLong(MODULE$.ARROW_FIXED_SIZE_LIST_SIZE_KEY(), (long)fixedSizeList.getListSize()).build();
            } else {
                metadata = Metadata$.MODULE$.empty();
            }
            Metadata metadata2 = metadata;
            return new StructField(field.getName(), dt, field.isNullable(), metadata2);
        })).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), MODULE$.deduplicateFieldNames(field.dataType(), errorOnDuplicatedFieldNames), field.nullable(), timeZoneId, largeVarTypes, field.metadata()))).asJava());
    }

    public boolean toArrowSchema$default$4() {
        return false;
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId, boolean largeVarTypes, Metadata metadata) {
        DataType dataType;
        while (true) {
            if ((dataType = dt) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (this.shouldBeFixedSizeList(metadata, elementType)) {
                    int listSize = (int)metadata.getLong(this.ARROW_FIXED_SIZE_LIST_SIZE_KEY());
                    FieldType fieldType = new FieldType(nullable, (ArrowType)new ArrowType.FixedSizeList(listSize), null);
                    return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
                }
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId, largeVarTypes, MODULE$.toArrowField$default$6()), ClassTag$.MODULE$.apply(Field.class))))).asJava());
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
                return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", (DataType)new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            metadata = this.toArrowField$default$6();
            dt = userDefinedType.sqlType();
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId, largeVarTypes, name), null);
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().empty()).asJava());
    }

    public boolean toArrowField$default$5() {
        return false;
    }

    public Metadata toArrowField$default$6() {
        return null;
    }

    private ArrowType toArrowType(DataType dt, String timeZoneId, boolean largeVarTypes, String name) {
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        boolean bl2 = false;
        StringType stringType = null;
        boolean bl3 = false;
        DataType dataType2 = null;
        boolean bl4 = false;
        DataType dataType3 = null;
        DataType dataType4 = dt;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType = dataType4;
            if (name.equals("_rowid")) {
                return new ArrowType.Int(64, false);
            }
        }
        if (bl) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (dataType4 instanceof StringType) {
            bl2 = true;
            stringType = (StringType)dataType4;
            if (!largeVarTypes) {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            bl3 = true;
            dataType2 = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Binary.INSTANCE;
            }
        }
        if (bl2 && largeVarTypes) {
            return ArrowType.LargeUtf8.INSTANCE;
        }
        if (bl3 && largeVarTypes) {
            return ArrowType.LargeBinary.INSTANCE;
        }
        if (dataType4 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType4)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale, 128);
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl4 = true;
            dataType3 = dataType4;
            if (timeZoneId == null) {
                throw SparkException$.MODULE$.internalError("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl4) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (NullType$.MODULE$.equals(dataType4)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType4 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType4 instanceof DayTimeIntervalType) {
            return new ArrowType.Duration(TimeUnit.MICROSECOND);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Interval(IntervalUnit.MONTH_DAY_NANO);
        }
        throw this.unsupportedDataTypeError(dt);
    }

    private boolean toArrowType$default$3() {
        return false;
    }

    private DataType deduplicateFieldNames(DataType dt, boolean errorOnDuplicatedFieldNames) {
        DataType dataType;
        while ((dataType = dt) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof StructType) {
            String[] stringArray;
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            if (Predef$.MODULE$.wrapRefArray((Object[])structType.names()).toSet().size() == structType.names().length) {
                stringArray = structType.names();
            } else {
                if (errorOnDuplicatedFieldNames) {
                    throw this.duplicatedFieldNameInArrowStructError((scala.collection.immutable.Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)structType.names()));
                }
                Map genNawName = (Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String[] names = (String[])tuple2._2();
                        if (names.length > 1) {
                            AtomicInteger i = new AtomicInteger();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> new StringBuilder(1).append(name).append("_").append(i.getAndIncrement()).toString());
                        }
                    }
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> name);
                    }
                    throw new MatchError((Object)tuple2);
                });
                stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x$1 -> (String)((Function0)genNawName.apply(x$1)).apply(), ClassTag$.MODULE$.apply(String.class));
            }
            String[] newNames = stringArray;
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newNames))), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    String name = (String)tuple2._2();
                    if (structField != null) {
                        DataType dataType = structField.dataType();
                        boolean nullable = structField.nullable();
                        Metadata metadata = structField.metadata();
                        return new StructField(name, MODULE$.deduplicateFieldNames(dataType, errorOnDuplicatedFieldNames), nullable, metadata);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(newFields);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return new ArrayType(this.deduplicateFieldNames(elementType, errorOnDuplicatedFieldNames), containsNull);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return new MapType(this.deduplicateFieldNames(keyType, errorOnDuplicatedFieldNames), this.deduplicateFieldNames(valueType, errorOnDuplicatedFieldNames), valueContainsNull);
        }
        return dt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldBeFixedSizeList(Metadata metadata, DataType elementType) {
        if (metadata == null) return false;
        if (!metadata.contains(this.ARROW_FIXED_SIZE_LIST_SIZE_KEY())) return false;
        if (metadata.getLong(this.ARROW_FIXED_SIZE_LIST_SIZE_KEY()) <= 0L) return false;
        DataType dataType = elementType;
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType == null) {
            if (floatType$ == null) return true;
        } else if (dataType.equals(floatType$)) return true;
        DataType dataType2 = elementType;
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        if (dataType2 != null) {
            if (!dataType2.equals(doubleType$)) return false;
            return true;
        }
        if (doubleType$ == null) return true;
        return false;
    }

    private SparkUnsupportedOperationException unsupportedDataTypeError(DataType typeName) {
        return new SparkUnsupportedOperationException("UNSUPPORTED_DATATYPE", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)new StringBuilder(2).append("\"").append(typeName.sql().toUpperCase(Locale.ROOT)).append("\"").toString())})));
    }

    private SparkUnsupportedOperationException duplicatedFieldNameInArrowStructError(scala.collection.immutable.Seq<String> fieldNames) {
        return new SparkUnsupportedOperationException("DUPLICATED_FIELD_NAME_IN_ARROW_STRUCT", (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)fieldNames.mkString("[", ", ", "]"))})));
    }

    private LanceArrowUtils$() {
    }
}

