/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.internal;

import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.internal.LanceFragmentScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.LanceArrowColumnVector;

public class LanceFragmentColumnarBatchScanner
implements AutoCloseable {
    private final LanceFragmentScanner fragmentScanner;
    private final ArrowReader arrowReader;
    private ColumnarBatch currentColumnarBatch;

    public LanceFragmentColumnarBatchScanner(LanceFragmentScanner fragmentScanner, ArrowReader arrowReader) {
        this.fragmentScanner = fragmentScanner;
        this.arrowReader = arrowReader;
    }

    public static LanceFragmentColumnarBatchScanner create(int fragmentId, LanceInputPartition inputPartition) {
        LanceFragmentScanner fragmentScanner = LanceDatasetAdapter.getFragmentScanner(fragmentId, inputPartition);
        return new LanceFragmentColumnarBatchScanner(fragmentScanner, fragmentScanner.getArrowReader());
    }

    public boolean loadNextBatch() throws IOException {
        if (this.currentColumnarBatch != null) {
            this.currentColumnarBatch.close();
        }
        if (this.arrowReader.loadNextBatch()) {
            VectorSchemaRoot root = this.arrowReader.getVectorSchemaRoot();
            this.currentColumnarBatch = new ColumnarBatch((ColumnVector[])root.getFieldVectors().stream().map(LanceArrowColumnVector::new).toArray(LanceArrowColumnVector[]::new), root.getRowCount());
            return true;
        }
        return false;
    }

    public ColumnarBatch getCurrentBatch() {
        return this.currentColumnarBatch;
    }

    @Override
    public void close() throws IOException {
        if (this.currentColumnarBatch != null) {
            this.currentColumnarBatch.close();
        }
        if (this.currentColumnarBatch != null) {
            this.currentColumnarBatch.close();
        }
        this.arrowReader.close();
        this.fragmentScanner.close();
    }
}

