/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.util.LanceArrowUtils;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.UInt8Accessor;
import org.apache.spark.unsafe.types.UTF8String;

public class LanceArrowColumnVector
extends ColumnVector {
    private UInt8Accessor uInt8Accessor;
    private ArrowColumnVector arrowColumnVector;

    public LanceArrowColumnVector(ValueVector vector) {
        super(LanceArrowUtils.fromArrowField(vector.getField()));
        if (vector instanceof UInt8Vector) {
            this.uInt8Accessor = new UInt8Accessor((UInt8Vector)vector);
        } else {
            this.arrowColumnVector = new ArrowColumnVector(vector);
        }
    }

    public void close() {
        if (this.uInt8Accessor != null) {
            this.uInt8Accessor.close();
        }
        if (this.arrowColumnVector != null) {
            this.arrowColumnVector.close();
        }
    }

    public boolean hasNull() {
        if (this.uInt8Accessor != null) {
            return this.uInt8Accessor.getNullCount() > 0;
        }
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.hasNull();
        }
        return false;
    }

    public int numNulls() {
        if (this.uInt8Accessor != null) {
            return this.uInt8Accessor.getNullCount();
        }
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.numNulls();
        }
        return 0;
    }

    public boolean isNullAt(int rowId) {
        if (this.uInt8Accessor != null) {
            return this.uInt8Accessor.isNullAt(rowId);
        }
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.isNullAt(rowId);
        }
        return false;
    }

    public boolean getBoolean(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getBoolean(rowId);
        }
        return false;
    }

    public byte getByte(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getByte(rowId);
        }
        return 0;
    }

    public short getShort(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getShort(rowId);
        }
        return 0;
    }

    public int getInt(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getInt(rowId);
        }
        return 0;
    }

    public long getLong(int rowId) {
        if (this.uInt8Accessor != null) {
            return this.uInt8Accessor.getLong(rowId);
        }
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getLong(rowId);
        }
        return 0L;
    }

    public float getFloat(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getFloat(rowId);
        }
        return 0.0f;
    }

    public double getDouble(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getDouble(rowId);
        }
        return 0.0;
    }

    public ColumnarArray getArray(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getArray(rowId);
        }
        return null;
    }

    public ColumnarMap getMap(int ordinal) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getMap(ordinal);
        }
        return null;
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getDecimal(rowId, precision, scale);
        }
        return null;
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getUTF8String(rowId);
        }
        return null;
    }

    public byte[] getBinary(int rowId) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getBinary(rowId);
        }
        return new byte[0];
    }

    public ColumnVector getChild(int ordinal) {
        if (this.arrowColumnVector != null) {
            return this.arrowColumnVector.getChild(ordinal);
        }
        return null;
    }
}

