/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class BaseBlobCreateTableTest {
    private SparkSession spark;
    private static final String catalogName = "lance_ns";
    @TempDir
    protected Path tempDir;

    @BeforeEach
    void setup() {
        this.spark = SparkSession.builder().appName("blob-create-table-test").master("local[*]").config("spark.sql.catalog.lance_ns", "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.catalog.lance_ns.impl", "dir").config("spark.sql.catalog.lance_ns.root", this.tempDir.toString()).getOrCreate();
    }

    @AfterEach
    void tearDown() {
        if (this.spark != null) {
            this.spark.stop();
        }
    }

    @Test
    public void testCreateTableWithBlobColumn() {
        String tableName = "blob_table_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, data BINARY) USING lance TBLPROPERTIES ('data.lance.encoding' = 'blob')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        ArrayList<Row> rows = new ArrayList<Row>();
        Random random = new Random(42L);
        for (int i = 0; i < 10; ++i) {
            byte[] largeData = new byte[100000];
            random.nextBytes(largeData);
            rows.add(RowFactory.create((Object[])new Object[]{i, largeData}));
        }
        Metadata blobMetadata = new MetadataBuilder().putString("lance-encoding:blob", "true").build();
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"data", (DataType)DataTypes.BinaryType, (boolean)true, (Metadata)blobMetadata)});
        Dataset df = this.spark.createDataFrame(rows, schema);
        try {
            df.writeTo("lance_ns.default." + tableName).append();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to append data to table: " + e.getMessage()));
        }
        Dataset result = this.spark.sql("SELECT COUNT(*) FROM lance_ns.default." + tableName);
        Assertions.assertEquals((long)10L, (long)((Row)result.collectAsList().get(0)).getLong(0));
        Dataset dataResult = this.spark.sql("SELECT id, data FROM lance_ns.default." + tableName + " WHERE id = 0");
        List dataRows = dataResult.collectAsList();
        Assertions.assertEquals((int)1, (int)dataRows.size());
        Assertions.assertEquals((int)0, (int)((Row)dataRows.get(0)).getInt(0));
        Object blobData = ((Row)dataRows.get(0)).get(1);
        Assertions.assertNotNull((Object)blobData);
        Assertions.assertTrue((boolean)(blobData instanceof byte[]), (String)"Blob data should be byte array");
        byte[] blobBytes = (byte[])blobData;
        Assertions.assertEquals((int)0, (int)blobBytes.length, (String)"Blob data should be empty (not materialized)");
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateEmptyTableWithBlobAndSQLInsert() {
        String tableName = "blob_empty_table_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, text STRING, blob_data BINARY) USING lance TBLPROPERTIES ('blob_data.lance.encoding' = 'blob')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        String testData1 = "This is test blob data 1";
        String testData2 = "This is test blob data 2";
        this.spark.sql("INSERT INTO lance_ns.default." + tableName + " VALUES (1, 'first text', X'" + this.bytesToHex(testData1.getBytes(StandardCharsets.UTF_8)) + "'), (2, 'second text', X'" + this.bytesToHex(testData2.getBytes(StandardCharsets.UTF_8)) + "')");
        Dataset result = this.spark.sql("SELECT COUNT(*) FROM lance_ns.default." + tableName);
        Assertions.assertEquals((long)2L, (long)((Row)result.collectAsList().get(0)).getLong(0));
        Dataset projection = this.spark.sql("SELECT id, text FROM lance_ns.default." + tableName + " ORDER BY id");
        List rows = projection.collectAsList();
        Assertions.assertEquals((int)2, (int)rows.size());
        Assertions.assertEquals((int)1, (int)((Row)rows.get(0)).getInt(0));
        Assertions.assertEquals((Object)"first text", (Object)((Row)rows.get(0)).getString(1));
        Assertions.assertEquals((int)2, (int)((Row)rows.get(1)).getInt(0));
        Assertions.assertEquals((Object)"second text", (Object)((Row)rows.get(1)).getString(1));
        Dataset blobQuery = this.spark.sql("SELECT id, blob_data FROM lance_ns.default." + tableName + " ORDER BY id");
        List blobRows = blobQuery.collectAsList();
        Assertions.assertEquals((int)2, (int)blobRows.size());
        for (Row row2 : blobRows) {
            Object blobData = row2.get(1);
            Assertions.assertNotNull((Object)blobData);
            Assertions.assertTrue((boolean)(blobData instanceof byte[]), (String)"Blob data should be byte array");
            byte[] blobBytes = (byte[])blobData;
            Assertions.assertEquals((int)0, (int)blobBytes.length, (String)"Blob data should be empty (not materialized)");
        }
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateTableWithMultipleBlobColumns() {
        String tableName = "blob_table_multi_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, blob1 BINARY, regular_binary BINARY, blob2 BINARY) USING lance TBLPROPERTIES ('blob1.lance.encoding' = 'blob', 'blob2.lance.encoding' = 'blob')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateTableWithInvalidBlobType() {
        String tableName = "blob_table_invalid_" + System.currentTimeMillis();
        try {
            this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, blob_data STRING) USING lance TBLPROPERTIES ('blob_data.lance.encoding' = 'blob')");
            Assertions.fail((String)"Should throw exception for non-binary blob column");
        }
        catch (Exception e) {
            Assertions.assertTrue((e.getMessage().contains("must have BINARY type") || e.getCause().getMessage().contains("must have BINARY type") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBlobVirtualColumns() {
        String tableName = "blob_virtual_columns_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, data BINARY) USING lance TBLPROPERTIES ('data.lance.encoding' = 'blob')");
        ArrayList<Row> rows = new ArrayList<Row>();
        Random random = new Random(42L);
        for (int i = 0; i < 5; ++i) {
            byte[] largeData = new byte[100000];
            random.nextBytes(largeData);
            rows.add(RowFactory.create((Object[])new Object[]{i, largeData}));
        }
        Metadata blobMetadata = new MetadataBuilder().putString("lance-encoding:blob", "true").build();
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"data", (DataType)DataTypes.BinaryType, (boolean)true, (Metadata)blobMetadata)});
        Dataset df = this.spark.createDataFrame(rows, schema);
        try {
            df.coalesce(1).writeTo("lance_ns.default." + tableName).append();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to append data to table: " + e.getMessage()));
        }
        Dataset result = this.spark.sql("SELECT id, data, data__blob_pos, data__blob_size FROM lance_ns.default." + tableName + " ORDER BY id");
        List resultRows = result.collectAsList();
        Assertions.assertEquals((int)5, (int)resultRows.size());
        HashSet<Long> positions = new HashSet<Long>();
        int positionCount = 0;
        for (Row row : resultRows) {
            Object blobData = row.get(1);
            Assertions.assertNotNull((Object)blobData);
            Assertions.assertTrue((boolean)(blobData instanceof byte[]), (String)"Blob data should be byte array");
            byte[] blobBytes = (byte[])blobData;
            Assertions.assertEquals((int)0, (int)blobBytes.length, (String)"Blob data should be empty (not materialized)");
            long position = row.getLong(2);
            long size = row.getLong(3);
            Assertions.assertTrue((position >= 0L ? 1 : 0) != 0, (String)"Blob position should be non-negative");
            Assertions.assertEquals((long)100000L, (long)size, (String)"Blob size should match original data size");
            positions.add(position);
            ++positionCount;
        }
        Assertions.assertEquals((int)5, (int)positionCount, (String)"All blob rows should have positions");
        Assertions.assertEquals((int)5, (int)positions.size(), (String)"All blob positions should be unique");
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            hexString.append(String.format("%02X", b));
        }
        return hexString.toString();
    }
}

