/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.spark.SparkLanceNamespaceTestBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTestSparkLanceDbRestNamespace
extends SparkLanceNamespaceTestBase {
    private static final Logger log = LoggerFactory.getLogger(BaseTestSparkLanceDbRestNamespace.class);
    protected static String DATABASE;
    protected static String API_KEY;
    protected static String HOST_OVERRIDE;
    protected static String REGION;

    @BeforeAll
    public static void setUpClass() {
        DATABASE = System.getenv("LANCEDB_DB");
        API_KEY = System.getenv("LANCEDB_API_KEY");
        HOST_OVERRIDE = System.getenv("LANCEDB_HOST_OVERRIDE");
        REGION = System.getenv("LANCEDB_REGION");
        if (BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(REGION)) {
            REGION = "us-east-1";
        }
        if (DATABASE != null && API_KEY != null) {
            log.info("Using configuration:");
            log.info("  Database: {}", (Object)DATABASE);
            log.info("  Region: {}", (Object)REGION);
            log.info("  Host Override: {}", (Object)(BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(HOST_OVERRIDE) ? "none" : HOST_OVERRIDE));
        }
    }

    @Override
    void setup() throws IOException {
        this.skipIfNotConfigured();
        super.setup();
    }

    @Override
    protected String getNsImpl() {
        return "rest";
    }

    @Override
    protected Map<String, String> getAdditionalNsConfigs() {
        String uri;
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("headers.x-api-key", API_KEY);
        configs.put("headers.x-lancedb-database", DATABASE);
        if (!BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(HOST_OVERRIDE)) {
            uri = HOST_OVERRIDE;
        } else {
            String effectiveRegion = BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(REGION) ? "us-east-1" : REGION;
            uri = String.format("https://%s.%s.api.lancedb.com", DATABASE, effectiveRegion);
        }
        configs.put("uri", uri);
        return configs;
    }

    protected void skipIfNotConfigured() {
        Assumptions.assumeTrue((!BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(DATABASE) && !BaseTestSparkLanceDbRestNamespace.isNullOrEmpty(API_KEY) ? 1 : 0) != 0, (String)"Skipping test: LANCEDB_DB and LANCEDB_API_KEY environment variables must be set");
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    @Override
    @Test
    public void testCreateAndDescribeTable() throws Exception {
        this.skipIfNotConfigured();
        super.testCreateAndDescribeTable();
    }

    @Override
    @Test
    public void testDropTable() throws Exception {
        this.skipIfNotConfigured();
        super.testDropTable();
    }

    @Override
    @Test
    public void testListTables() throws Exception {
        this.skipIfNotConfigured();
        super.testListTables();
    }

    @Override
    @Test
    public void testSparkSqlJoin() throws Exception {
        this.skipIfNotConfigured();
        super.testSparkSqlJoin();
    }

    @Override
    @Test
    public void testSparkSqlSelect() throws Exception {
        this.skipIfNotConfigured();
        super.testSparkSqlSelect();
    }

    @Override
    @Test
    public void testLoadSparkTable() throws Exception {
        this.skipIfNotConfigured();
        super.testLoadSparkTable();
    }
}

