/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.TestUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanceConfigTest {
    @Test
    public void testLanceConfigFromCaseInsensitiveStringMap() {
        String dbPath = "file://path/to/db/";
        String datasetName = "testDatasetName";
        final String datasetUri = TestUtils.getDatasetUri(dbPath, datasetName);
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)new HashMap<String, String>(){
            {
                this.put("path", datasetUri);
            }
        });
        LanceConfig config = LanceConfig.from((CaseInsensitiveStringMap)options);
        Assertions.assertEquals((Object)dbPath, (Object)config.getDbPath());
        Assertions.assertEquals((Object)datasetName, (Object)config.getDatasetName());
        Assertions.assertEquals((Object)datasetUri, (Object)config.getDatasetUri());
    }

    @Test
    public void testLanceConfigFromCaseInsensitiveStringMap2() {
        String dbPath = "s3://bucket/folder/";
        String datasetName = "testDatasetName";
        final String datasetUri = TestUtils.getDatasetUri(dbPath, datasetName);
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)new HashMap<String, String>(){
            {
                this.put("path", datasetUri);
            }
        });
        LanceConfig config = LanceConfig.from((CaseInsensitiveStringMap)options);
        Assertions.assertEquals((Object)dbPath, (Object)config.getDbPath());
        Assertions.assertEquals((Object)datasetName, (Object)config.getDatasetName());
        Assertions.assertEquals((Object)datasetUri, (Object)config.getDatasetUri());
    }

    @Test
    public void testLanceConfigFromMap() {
        String dbPath = "file://path/to/db/";
        String datasetName = "testDatasetName";
        String datasetUri = TestUtils.getDatasetUri(dbPath, datasetName);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", datasetUri);
        LanceConfig config = LanceConfig.from(properties);
        Assertions.assertEquals((Object)dbPath, (Object)config.getDbPath());
        Assertions.assertEquals((Object)datasetName, (Object)config.getDatasetName());
        Assertions.assertEquals((Object)datasetUri, (Object)config.getDatasetUri());
    }

    @Test
    public void testLanceConfigFromMap2() {
        String dbPath = "s3://bucket/folder/";
        String datasetName = "testDatasetName";
        String datasetUri = TestUtils.getDatasetUri(dbPath, datasetName);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", datasetUri);
        LanceConfig config = LanceConfig.from(properties);
        Assertions.assertEquals((Object)dbPath, (Object)config.getDbPath());
        Assertions.assertEquals((Object)datasetName, (Object)config.getDatasetName());
        Assertions.assertEquals((Object)datasetUri, (Object)config.getDatasetUri());
    }
}

