/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.read.LanceInputPartition;
import com.lancedb.lance.spark.read.LanceSplit;
import com.lancedb.lance.spark.utils.Optional;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class TestUtils {
    public static String getDatasetUri(String dbPath, String datasetUri) {
        StringBuilder sb = new StringBuilder().append(dbPath);
        if (!dbPath.endsWith("/")) {
            sb.append("/");
        }
        if (dbPath.equals(TestTable1Config.dbPath) && datasetUri.startsWith("test_dataset")) {
            return sb.append(datasetUri).append(".lance").toString();
        }
        return sb.append(datasetUri).toString();
    }

    public static class TestTable1Config {
        public static final String dbPath;
        public static final String datasetName = "test_dataset1";
        public static final String datasetUri;
        public static final List<List<Long>> expectedValues;
        public static final List<List<Long>> expectedValuesWithRowId;
        public static final List<List<Long>> expectedValuesWithRowAddress;
        public static final LanceConfig lanceConfig;
        public static final StructType schema;
        public static final LanceInputPartition inputPartition;

        static {
            expectedValues = Arrays.asList(Arrays.asList(0L, 0L, 0L, 0L), Arrays.asList(1L, 2L, 3L, -1L), Arrays.asList(2L, 4L, 6L, -2L), Arrays.asList(3L, 6L, 9L, -3L));
            expectedValuesWithRowId = Arrays.asList(Arrays.asList(0L, 0L, 0L, 0L, 0L), Arrays.asList(1L, 2L, 3L, -1L, 1L), Arrays.asList(2L, 4L, 6L, -2L, 0x100000000L), Arrays.asList(3L, 6L, 9L, -3L, 0x100000001L));
            expectedValuesWithRowAddress = Arrays.asList(Arrays.asList(0L, 0L, 0L, 0L, 0L), Arrays.asList(1L, 2L, 3L, -1L, 1L), Arrays.asList(2L, 4L, 6L, -2L, 0x100000000L), Arrays.asList(3L, 6L, 9L, -3L, 0x100000001L));
            schema = new StructType(new StructField[]{DataTypes.createStructField((String)"x", (DataType)DataTypes.LongType, (boolean)true), DataTypes.createStructField((String)"y", (DataType)DataTypes.LongType, (boolean)true), DataTypes.createStructField((String)"b", (DataType)DataTypes.LongType, (boolean)true), DataTypes.createStructField((String)"c", (DataType)DataTypes.LongType, (boolean)true)});
            URL resource = TestUtils.class.getResource("/example_db");
            if (resource == null) {
                throw new IllegalArgumentException("example_db not found in resources directory");
            }
            dbPath = resource.toString();
            datasetUri = TestUtils.getDatasetUri(dbPath, datasetName);
            lanceConfig = LanceConfig.from((String)datasetUri);
            inputPartition = new LanceInputPartition(schema, 0, new LanceSplit(Arrays.asList(0, 1)), lanceConfig, Optional.empty(), "test");
        }
    }
}

