/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.ipc.ColumnOrdering;
import com.lancedb.lance.spark.TestUtils;
import com.lancedb.lance.spark.read.LanceColumnarPartitionReader;
import com.lancedb.lance.spark.read.LanceInputPartition;
import com.lancedb.lance.spark.read.LanceSplit;
import com.lancedb.lance.spark.utils.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanceColumnarPartitionReaderTest {
    @Test
    public void test() throws Exception {
        LanceSplit split = new LanceSplit(Arrays.asList(0, 1));
        LanceInputPartition partition = new LanceInputPartition(TestUtils.TestTable1Config.schema, 0, split, TestUtils.TestTable1Config.lanceConfig, Optional.empty(), "test");
        try (LanceColumnarPartitionReader reader = new LanceColumnarPartitionReader(partition);){
            List<List<Long>> expectedValues = TestUtils.TestTable1Config.expectedValues;
            int rowIndex = 0;
            while (reader.next()) {
                ColumnarBatch batch = reader.get();
                Assertions.assertNotNull((Object)batch);
                for (int i = 0; i < batch.numRows(); ++i) {
                    for (int j = 0; j < batch.numCols(); ++j) {
                        long actualValue = batch.column(j).getLong(i);
                        long expectedValue = expectedValues.get(rowIndex).get(j);
                        Assertions.assertEquals((long)expectedValue, (long)actualValue, (String)("Mismatch at row " + rowIndex + " column " + j));
                    }
                    ++rowIndex;
                }
                batch.close();
            }
            Assertions.assertEquals((int)expectedValues.size(), (int)rowIndex);
        }
    }

    @Test
    public void testOffsetAndLimit() throws Exception {
        LanceSplit split = new LanceSplit(Collections.singletonList(0));
        LanceInputPartition partition = new LanceInputPartition(TestUtils.TestTable1Config.schema, 0, split, TestUtils.TestTable1Config.lanceConfig, Optional.empty(), Optional.of((Object)1), Optional.of((Object)1), Optional.empty(), Optional.empty(), "testOffsetAndLimit");
        try (LanceColumnarPartitionReader reader = new LanceColumnarPartitionReader(partition);){
            List<List<Long>> expectedValues = TestUtils.TestTable1Config.expectedValues;
            int rowIndex = 1;
            while (reader.next()) {
                ColumnarBatch batch = reader.get();
                Assertions.assertNotNull((Object)batch);
                Assertions.assertEquals((int)1, (int)batch.numRows());
                for (int i = 0; i < batch.numRows(); ++i) {
                    for (int j = 0; j < batch.numCols(); ++j) {
                        long actualValue = batch.column(j).getLong(i);
                        long expectedValue = expectedValues.get(rowIndex).get(j);
                        Assertions.assertEquals((long)expectedValue, (long)actualValue, (String)("Mismatch at row " + rowIndex + " column " + j));
                    }
                    ++rowIndex;
                }
                batch.close();
            }
        }
    }

    @Test
    public void testTopN() throws Exception {
        LanceSplit split = new LanceSplit(Collections.singletonList(1));
        ColumnOrdering.Builder builder = new ColumnOrdering.Builder();
        builder.setNullFirst(true);
        builder.setAscending(false);
        builder.setColumnName("b");
        LanceInputPartition partition = new LanceInputPartition(TestUtils.TestTable1Config.schema, 0, split, TestUtils.TestTable1Config.lanceConfig, Optional.empty(), Optional.of((Object)1), Optional.empty(), Optional.of(Collections.singletonList(builder.build())), Optional.empty(), "testTopN");
        try (LanceColumnarPartitionReader reader = new LanceColumnarPartitionReader(partition);){
            List<List<Long>> expectedValues = TestUtils.TestTable1Config.expectedValues;
            int rowIndex = 3;
            while (reader.next()) {
                ColumnarBatch batch = reader.get();
                Assertions.assertNotNull((Object)batch);
                Assertions.assertEquals((int)1, (int)batch.numRows());
                for (int i = 0; i < batch.numRows(); ++i) {
                    for (int j = 0; j < batch.numCols(); ++j) {
                        long actualValue = batch.column(j).getLong(i);
                        long expectedValue = expectedValues.get(rowIndex).get(j);
                        Assertions.assertEquals((long)expectedValue, (long)actualValue, (String)("Mismatch at row " + rowIndex + " column " + j));
                    }
                }
                batch.close();
            }
        }
    }
}

