/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.TestUtils;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.internal.LanceFragmentScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import com.lancedb.lance.spark.read.LanceSplit;
import com.lancedb.lance.spark.utils.Optional;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanceDatasetReadTest {
    @Test
    public void testSchema() {
        StructType expectedSchema = TestUtils.TestTable1Config.schema;
        Optional schema = LanceDatasetAdapter.getSchema((LanceConfig)TestUtils.TestTable1Config.lanceConfig);
        Assertions.assertTrue((boolean)schema.isPresent());
        Assertions.assertEquals((Object)expectedSchema, (Object)schema.get());
    }

    @Test
    public void testFragmentIds() {
        List fragments = LanceDatasetAdapter.getFragmentIds((LanceConfig)TestUtils.TestTable1Config.lanceConfig);
        Assertions.assertEquals((int)2, (int)fragments.size());
        Assertions.assertEquals((int)0, (Integer)((Integer)fragments.get(0)));
        Assertions.assertEquals((int)1, (Integer)((Integer)fragments.get(1)));
    }

    @Test
    public void getFragmentScanner() throws IOException {
        List<List<Object>> expectedValues = Arrays.asList(Arrays.asList(0L, 0L, 0L, 0L), Arrays.asList(1L, 2L, 3L, -1L));
        this.validateFragment(expectedValues, 0, TestUtils.TestTable1Config.schema);
        List<List<Object>> expectedValues1 = Arrays.asList(Arrays.asList(2L, 4L, 6L, -2L), Arrays.asList(3L, 6L, 9L, -3L));
        this.validateFragment(expectedValues1, 1, TestUtils.TestTable1Config.schema);
        List<List<Object>> expectedValuesColumnsyb = Arrays.asList(Arrays.asList(4L, 6L), Arrays.asList(6L, 9L));
        this.validateFragment(expectedValuesColumnsyb, 1, new StructType(new StructField[]{DataTypes.createStructField((String)"y", (DataType)DataTypes.LongType, (boolean)true), DataTypes.createStructField((String)"b", (DataType)DataTypes.LongType, (boolean)true)}));
        List<List<Object>> expectedValuesColumnsbc = Arrays.asList(Arrays.asList(0L, 0L), Arrays.asList(3L, -1L));
        this.validateFragment(expectedValuesColumnsbc, 0, new StructType(new StructField[]{DataTypes.createStructField((String)"b", (DataType)DataTypes.LongType, (boolean)true), DataTypes.createStructField((String)"c", (DataType)DataTypes.LongType, (boolean)true)}));
    }

    public void validateFragment(List<List<Object>> expectedValues, int fragment, StructType schema) throws IOException {
        try (LanceFragmentScanner scanner = LanceDatasetAdapter.getFragmentScanner((int)fragment, (LanceInputPartition)new LanceInputPartition(schema, 0, new LanceSplit(Arrays.asList(fragment)), TestUtils.TestTable1Config.lanceConfig, Optional.empty(), "validateFragment"));
             ArrowReader reader = scanner.getArrowReader();){
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            Assertions.assertNotNull((Object)root);
            while (reader.loadNextBatch()) {
                for (int i = 0; i < root.getRowCount(); ++i) {
                    for (int j = 0; j < root.getFieldVectors().size(); ++j) {
                        Assertions.assertEquals((Object)expectedValues.get(i).get(j), (Object)((FieldVector)root.getFieldVectors().get(j)).getObject(i));
                    }
                }
            }
        }
    }
}

