/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.TestUtils;
import com.lancedb.lance.spark.internal.LanceFragmentColumnarBatchScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanceFragmentColumnarBatchScannerTest {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void scanner() throws IOException {
        List<List<Long>> expectedValues = TestUtils.TestTable1Config.expectedValues;
        int rowIndex = 0;
        int fragmentId = 0;
        while (true) {
            if (fragmentId > 1) {
                Assertions.assertEquals((int)4, (int)rowIndex);
                return;
            }
            try (LanceFragmentColumnarBatchScanner scanner = LanceFragmentColumnarBatchScanner.create((int)fragmentId, (LanceInputPartition)TestUtils.TestTable1Config.inputPartition);){
                while (scanner.loadNextBatch()) {
                    ColumnarBatch batch = scanner.getCurrentBatch();
                    try {
                        Iterator rows = batch.rowIterator();
                        while (rows.hasNext()) {
                            InternalRow row = (InternalRow)rows.next();
                            Assertions.assertNotNull((Object)row);
                            for (int colIndex = 0; colIndex < row.numFields(); ++colIndex) {
                                long actualValue = row.getLong(colIndex);
                                long expectedValue = expectedValues.get(rowIndex).get(colIndex);
                                Assertions.assertEquals((long)expectedValue, (long)actualValue, (String)("Mismatch at row " + rowIndex + " column " + colIndex));
                            }
                            ++rowIndex;
                        }
                    }
                    finally {
                        if (batch == null) continue;
                        batch.close();
                    }
                }
            }
            ++fragmentId;
        }
    }
}

