/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.spark.write.LanceArrowWriter;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class LanceArrowWriterTest {
    @Test
    public void test() throws Exception {
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);){
            Field field = new Field("column1", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), null);
            Schema schema = new Schema(Collections.singletonList(field));
            StructType sparkSchema = new StructType(new StructField[]{DataTypes.createStructField((String)"column1", (DataType)DataTypes.IntegerType, (boolean)true)});
            int totalRows = 125;
            int batchSize = 34;
            LanceArrowWriter arrowWriter = new LanceArrowWriter((BufferAllocator)allocator, schema, sparkSchema, 34);
            AtomicInteger rowsWritten = new AtomicInteger(0);
            AtomicInteger rowsRead = new AtomicInteger(0);
            AtomicLong expectedBytesRead = new AtomicLong(0L);
            Thread writerThread = new Thread(() -> {
                try {
                    for (int i = 0; i < 125; ++i) {
                        GenericInternalRow row = new GenericInternalRow(new Object[]{rowsWritten.incrementAndGet()});
                        arrowWriter.write((InternalRow)row);
                    }
                    arrowWriter.setFinished();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            });
            Thread readerThread = new Thread(() -> {
                try {
                    while (arrowWriter.loadNextBatch()) {
                        VectorSchemaRoot root = arrowWriter.getVectorSchemaRoot();
                        int rowCount = root.getRowCount();
                        rowsRead.addAndGet(rowCount);
                        try (ArrowRecordBatch recordBatch = new VectorUnloader(root).getRecordBatch();){
                            expectedBytesRead.addAndGet(recordBatch.computeBodyLength());
                        }
                        for (int i = 0; i < rowCount; ++i) {
                            int value = (Integer)root.getVector("column1").getObject(i);
                            Assertions.assertEquals((int)value, (int)(rowsRead.get() - rowCount + i + 1));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            writerThread.start();
            readerThread.start();
            writerThread.join();
            readerThread.join();
            Assertions.assertEquals((int)125, (int)rowsWritten.get());
            Assertions.assertEquals((int)125, (int)rowsRead.get());
            arrowWriter.close();
        }
    }
}

