/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.TestUtils;
import com.lancedb.lance.spark.write.LanceBatchWrite;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.LanceArrowUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;

public class LanceBatchWriteTest {
    @TempDir
    static Path tempDir;

    @Test
    public void testLanceDataWriter(TestInfo testInfo) throws Exception {
        String datasetName = ((Method)testInfo.getTestMethod().get()).getName();
        String datasetUri = TestUtils.getDatasetUri(tempDir.toString(), datasetName);
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);){
            WriterCommitMessage message;
            Field field = new Field("column1", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
            Schema schema = new Schema(Collections.singletonList(field));
            Dataset.create((BufferAllocator)allocator, (String)datasetUri, (Schema)schema, (WriteParams)new WriteParams.Builder().build()).close();
            LanceConfig config = LanceConfig.from((String)datasetUri);
            StructType sparkSchema = LanceArrowUtils.fromArrowSchema((Schema)schema);
            LanceBatchWrite lanceBatchWrite = new LanceBatchWrite(sparkSchema, config, false);
            DataWriterFactory factor = lanceBatchWrite.createBatchWriterFactory(() -> 1);
            int rows = 132;
            try (DataWriter writer = factor.createWriter(0, 0L);){
                for (int i = 0; i < rows; ++i) {
                    GenericInternalRow row = new GenericInternalRow(new Object[]{i});
                    writer.write((Object)row);
                }
                message = writer.commit();
            }
            lanceBatchWrite.commit(new WriterCommitMessage[]{message});
            try (Dataset dataset = Dataset.open((String)datasetUri, (BufferAllocator)allocator);
                 LanceScanner scanner = dataset.newScan();
                 ArrowReader reader = scanner.scanBatches();){
                VectorSchemaRoot readerRoot = reader.getVectorSchemaRoot();
                int totalRowsRead = 0;
                while (reader.loadNextBatch()) {
                    int batchRows = readerRoot.getRowCount();
                    for (int i = 0; i < batchRows; ++i) {
                        int value = (Integer)readerRoot.getVector("column1").getObject(i);
                        Assertions.assertEquals((int)(totalRowsRead + i), (int)value);
                    }
                    totalRowsRead += batchRows;
                }
                Assertions.assertEquals((int)rows, (int)totalRowsRead);
            }
        }
    }
}

