/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.write.LanceBatchWrite;
import com.lancedb.lance.spark.write.LanceDataWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.LanceArrowUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;

public class LanceDataWriterTest {
    @TempDir
    static Path tempDir;

    @Test
    public void testLanceDataWriter(TestInfo testInfo) throws IOException {
        String datasetName = ((Method)testInfo.getTestMethod().get()).getName();
        try (RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);){
            Field field = new Field("column1", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
            Schema schema = new Schema(Collections.singletonList(field));
            LanceConfig config = LanceConfig.from((String)tempDir.resolve(datasetName + ".lance").toString());
            StructType sparkSchema = LanceArrowUtils.fromArrowSchema((Schema)schema);
            LanceDataWriter.WriterFactory writerFactory = new LanceDataWriter.WriterFactory(sparkSchema, config);
            LanceDataWriter dataWriter = (LanceDataWriter)writerFactory.createWriter(0, 0L);
            int rows = 132;
            for (int i = 0; i < rows; ++i) {
                GenericInternalRow row = new GenericInternalRow(new Object[]{i});
                dataWriter.write((InternalRow)row);
            }
            LanceBatchWrite.TaskCommit commitMessage = (LanceBatchWrite.TaskCommit)dataWriter.commit();
            dataWriter.close();
            List fragments = commitMessage.getFragments();
            Assertions.assertEquals((int)1, (int)fragments.size());
            Assertions.assertEquals((long)rows, (long)((FragmentMetadata)fragments.get(0)).getPhysicalRows());
        }
    }
}

