/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.LanceArrowUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00193A\u0001B\u0003\u0001!!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!9!\bAI\u0001\n\u0003Y$\u0001\u0006'b]\u000e,\u0017I\u001d:poV#\u0018\u000e\\:Tk&$XM\u0003\u0002\u0007\u000f\u0005!Q\u000f^5m\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005Aa-\u001e8tk&$XM\u0003\u0002\u0017\u001b\u0005I1oY1mCR,7\u000f^\u0005\u00031M\u00111\"\u00118z\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!B\u0001\ne>,h\u000e\u001a;sSB$2aH\u0013.!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0011)f.\u001b;\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u0005\u0011$\bC\u0001\u0015,\u001b\u0005I#B\u0001\u0016\b\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0013F\u0001\u0005ECR\fG+\u001f9f\u0011\u001dq#\u0001%AA\u0002=\n\u0011BZ5fY\u0012t\u0015-\\3\u0011\u0005A:dBA\u00196!\t\u0011\u0014%D\u00014\u0015\t!t\"\u0001\u0004=e>|GOP\u0005\u0003m\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a'I\u0001\u0014e>,h\u000e\u001a;sSB$C-\u001a4bk2$HEM\u000b\u0002y)\u0012q&P\u0016\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nk:\u001c\u0007.Z2lK\u0012T!aQ\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002F\u0001\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LanceArrowUtilsSuite
extends AnyFunSuite {
    public void roundtrip(DataType dt, String fieldName) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(LanceArrowUtils$.MODULE$.fromArrowSchema(LanceArrowUtils$.MODULE$.toArrowSchema(structType, null, true, LanceArrowUtils$.MODULE$.toArrowSchema$default$4())));
            StructType $org_scalatest_assert_macro_right = structType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            return;
        }
        this.roundtrip((DataType)new StructType().add(fieldName, dt), this.roundtrip$default$2());
    }

    public String roundtrip$default$2() {
        return "value";
    }

    private final void roundtripWithTz$1(String timeZoneId) {
        StructType schema = new StructType().add("value", (DataType)TimestampType$.MODULE$);
        Schema arrowSchema = LanceArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId, true, LanceArrowUtils$.MODULE$.toArrowSchema$default$4());
        ArrowType.Timestamp fieldType = (ArrowType.Timestamp)arrowSchema.findField("value").getType();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fieldType.getTimezone());
        String $org_scalatest_assert_macro_right = timeZoneId;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(LanceArrowUtils$.MODULE$.fromArrowSchema(arrowSchema));
        StructType $org_scalatest_assert_macro_right2 = schema;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    private final void check$1(DataType dt, DataType expected) {
        StructType schema = new StructType().add("value", dt);
        this.intercept((Function0 & Serializable & scala.Serializable)() -> LanceArrowUtils$.MODULE$.toArrowSchema(schema, null, true, LanceArrowUtils$.MODULE$.toArrowSchema$default$4()), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(LanceArrowUtils$.MODULE$.fromArrowSchema(LanceArrowUtils$.MODULE$.toArrowSchema(schema, null, false, LanceArrowUtils$.MODULE$.toArrowSchema$default$4())));
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", expected);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
    }

    public LanceArrowUtilsSuite() {
        this.test("unsigned long", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)BooleanType$.MODULE$, "_rowid");
            Field arrowType = LanceArrowUtils$.MODULE$.toArrowField("_rowid", (DataType)LongType$.MODULE$, true, "Beijing", LanceArrowUtils$.MODULE$.toArrowField$default$5(), LanceArrowUtils$.MODULE$.toArrowField$default$6());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((ArrowType.Int)arrowType.getType()).getBitWidth()));
            int $org_scalatest_assert_macro_right = 64;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ArrowType.Int)arrowType.getType()).getIsSigned(), "arrowType.getType().asInstanceOf[org.apache.arrow.vector.types.pojo.ArrowType.Int].getIsSigned()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("simple", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)BooleanType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)ByteType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)ShortType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)IntegerType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)LongType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)FloatType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)DoubleType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)StringType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)BinaryType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.roundtrip$default$2());
            this.roundtrip((DataType)DateType$.MODULE$, this.roundtrip$default$2());
            this.roundtrip((DataType)YearMonthIntervalType$.MODULE$.apply(), this.roundtrip$default$2());
            this.roundtrip((DataType)DayTimeIntervalType$.MODULE$.apply(), this.roundtrip$default$2());
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtripWithTz$1(ZoneId.systemDefault().getId());
            this.roundtripWithTz$1("Asia/Tokyo");
            this.roundtripWithTz$1("UTC");
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), this.roundtrip$default$2());
            this.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), this.roundtrip$default$2());
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true), this.roundtrip$default$2());
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true), this.roundtrip$default$2());
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false), this.roundtrip$default$2());
            this.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false), this.roundtrip$default$2());
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)new StructType(), this.roundtrip$default$2());
            this.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$), this.roundtrip$default$2());
            this.roundtrip((DataType)new StructType().add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.roundtrip$default$2());
            this.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), this.roundtrip$default$2());
            this.roundtrip((DataType)new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))), this.roundtrip$default$2());
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("struct with duplicated field names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("i", (DataType)StringType$.MODULE$), this.roundtrip$default$2());
            this.check$1((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("i", (DataType)StringType$.MODULE$), (DataType)new StructType().add("i_0", (DataType)IntegerType$.MODULE$).add("i_1", (DataType)StringType$.MODULE$));
            this.check$1((DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("i", (DataType)StringType$.MODULE$)), (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("i_0", (DataType)IntegerType$.MODULE$).add("i_1", (DataType)StringType$.MODULE$)));
            this.check$1((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("i", (DataType)StringType$.MODULE$)), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)new StructType().add("i_0", (DataType)IntegerType$.MODULE$).add("i_1", (DataType)StringType$.MODULE$)));
        }, new Position("LanceArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
    }
}

