/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.utils;

import com.lancedb.lance.namespace.model.JsonArrowDataType;
import com.lancedb.lance.namespace.model.JsonArrowField;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.spark.utils.VectorUtils;
import java.util.ArrayList;
import java.util.Map;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;

public class SchemaConverter {
    private SchemaConverter() {
    }

    public static JsonArrowSchema toJsonArrowSchema(StructType sparkSchema) {
        JsonArrowSchema jsonSchema = new JsonArrowSchema();
        ArrayList<JsonArrowField> fields = new ArrayList<JsonArrowField>();
        for (StructField sparkField : sparkSchema.fields()) {
            fields.add(SchemaConverter.toJsonArrowField(sparkField));
        }
        jsonSchema.setFields(fields);
        return jsonSchema;
    }

    public static StructType processSchemaWithProperties(StructType sparkSchema, Map<String, String> properties) {
        StructType schemaWithVectors = SchemaConverter.addVectorMetadata(sparkSchema, properties);
        return SchemaConverter.addBlobMetadata(schemaWithVectors, properties);
    }

    private static StructType addVectorMetadata(StructType sparkSchema, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return sparkSchema;
        }
        StructField[] newFields = new StructField[sparkSchema.fields().length];
        for (int i = 0; i < sparkSchema.fields().length; ++i) {
            StructField field = sparkSchema.fields()[i];
            String vectorSizeProperty = VectorUtils.createVectorSizePropertyKey(field.name());
            if (properties.containsKey(vectorSizeProperty)) {
                if (field.dataType() instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)field.dataType();
                    DataType elementType = arrayType.elementType();
                    if (elementType instanceof FloatType || elementType instanceof DoubleType) {
                        Long vectorSize = Long.parseLong(properties.get(vectorSizeProperty));
                        Metadata newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putLong("arrow.fixed-size-list.size", vectorSize.longValue()).build();
                        newFields[i] = new StructField(field.name(), field.dataType(), field.nullable(), newMetadata);
                        continue;
                    }
                    throw new IllegalArgumentException("Vector column '" + field.name() + "' must have element type FLOAT or DOUBLE, found: " + elementType);
                }
                throw new IllegalArgumentException("Column '" + field.name() + "' has vector property but is not an ARRAY type: " + field.dataType());
            }
            newFields[i] = field;
        }
        return new StructType(newFields);
    }

    private static StructType addBlobMetadata(StructType sparkSchema, Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return sparkSchema;
        }
        StructField[] newFields = new StructField[sparkSchema.fields().length];
        for (int i = 0; i < sparkSchema.fields().length; ++i) {
            StructField field = sparkSchema.fields()[i];
            String blobEncodingProperty = field.name() + ".lance.encoding";
            if (properties.containsKey(blobEncodingProperty)) {
                String encodingValue = properties.get(blobEncodingProperty);
                if ("blob".equalsIgnoreCase(encodingValue)) {
                    if (field.dataType() instanceof BinaryType) {
                        Metadata newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putString("lance-encoding:blob", "true").build();
                        newFields[i] = new StructField(field.name(), field.dataType(), field.nullable(), newMetadata);
                        continue;
                    }
                    throw new IllegalArgumentException("Blob column '" + field.name() + "' must have BINARY type, found: " + field.dataType());
                }
                newFields[i] = field;
                continue;
            }
            newFields[i] = field;
        }
        return new StructType(newFields);
    }

    private static JsonArrowField toJsonArrowField(StructField sparkField) {
        JsonArrowField field = new JsonArrowField();
        field.setName(sparkField.name());
        field.setNullable(Boolean.valueOf(sparkField.nullable()));
        field.setType(SchemaConverter.toJsonArrowDataType(sparkField.dataType(), sparkField.name(), sparkField.metadata()));
        return field;
    }

    private static JsonArrowDataType toJsonArrowDataType(DataType sparkType, String fieldName) {
        return SchemaConverter.toJsonArrowDataType(sparkType, fieldName, null);
    }

    private static JsonArrowDataType toJsonArrowDataType(DataType sparkType, String fieldName, Metadata metadata) {
        JsonArrowDataType dataType = new JsonArrowDataType();
        if (sparkType instanceof BooleanType) {
            dataType.setType("bool");
        } else if (sparkType instanceof ByteType) {
            dataType.setType("int8");
        } else if (sparkType instanceof ShortType) {
            dataType.setType("int16");
        } else if (sparkType instanceof IntegerType) {
            dataType.setType("int32");
        } else if (sparkType instanceof LongType) {
            dataType.setType("int64");
        } else if (sparkType instanceof FloatType) {
            dataType.setType("float32");
        } else if (sparkType instanceof DoubleType) {
            dataType.setType("float64");
        } else if (sparkType instanceof StringType) {
            dataType.setType("string");
        } else if (sparkType instanceof BinaryType) {
            dataType.setType("binary");
        } else if (sparkType instanceof DateType) {
            dataType.setType("date");
        } else if (sparkType instanceof TimestampType) {
            dataType.setType("timestamp");
        } else if (sparkType instanceof TimestampNTZType) {
            dataType.setType("timestamp");
        } else if (sparkType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)sparkType;
            dataType.setType("decimal");
        } else if (sparkType instanceof NullType) {
            dataType.setType("null");
        } else if (sparkType instanceof YearMonthIntervalType) {
            dataType.setType("interval");
        } else if (sparkType instanceof DayTimeIntervalType) {
            dataType.setType("duration");
        } else if (sparkType instanceof CalendarIntervalType) {
            dataType.setType("interval");
        } else if (sparkType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)sparkType;
            boolean isFixedSizeList = false;
            Long fixedSize = null;
            if (metadata != null && metadata.contains("arrow.fixed-size-list.size")) {
                try {
                    fixedSize = metadata.getLong("arrow.fixed-size-list.size");
                    isFixedSizeList = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isFixedSizeList && fixedSize != null) {
                dataType.setType("fixedsizelist");
                dataType.setLength(fixedSize);
            } else {
                dataType.setType("list");
            }
            JsonArrowField itemField = new JsonArrowField();
            itemField.setName("item");
            itemField.setNullable(Boolean.valueOf(arrayType.containsNull()));
            itemField.setType(SchemaConverter.toJsonArrowDataType(arrayType.elementType(), "item", null));
            ArrayList<JsonArrowField> fields = new ArrayList<JsonArrowField>();
            fields.add(itemField);
            dataType.setFields(fields);
        } else if (sparkType instanceof StructType) {
            StructType structType = (StructType)sparkType;
            dataType.setType("struct");
            ArrayList<JsonArrowField> fields = new ArrayList<JsonArrowField>();
            for (StructField field : structType.fields()) {
                fields.add(SchemaConverter.toJsonArrowField(field));
            }
            dataType.setFields(fields);
        } else if (sparkType instanceof MapType) {
            MapType mapType = (MapType)sparkType;
            dataType.setType("map");
            ArrayList<JsonArrowField> fields = new ArrayList<JsonArrowField>();
            JsonArrowField mapStructField = new JsonArrowField();
            mapStructField.setName("entries");
            mapStructField.setNullable(Boolean.valueOf(false));
            JsonArrowDataType mapStructType = new JsonArrowDataType();
            mapStructType.setType("struct");
            ArrayList<JsonArrowField> structFields = new ArrayList<JsonArrowField>();
            JsonArrowField keyField = new JsonArrowField();
            keyField.setName("key");
            keyField.setNullable(Boolean.valueOf(false));
            keyField.setType(SchemaConverter.toJsonArrowDataType(mapType.keyType(), "key"));
            structFields.add(keyField);
            JsonArrowField valueField = new JsonArrowField();
            valueField.setName("value");
            valueField.setNullable(Boolean.valueOf(mapType.valueContainsNull()));
            valueField.setType(SchemaConverter.toJsonArrowDataType(mapType.valueType(), "value"));
            structFields.add(valueField);
            mapStructType.setFields(structFields);
            mapStructField.setType(mapStructType);
            fields.add(mapStructField);
            dataType.setFields(fields);
        } else {
            if (sparkType instanceof UserDefinedType) {
                UserDefinedType udt = (UserDefinedType)sparkType;
                return SchemaConverter.toJsonArrowDataType(udt.sqlType(), fieldName);
            }
            throw new IllegalArgumentException("Unsupported Spark data type: " + sparkType);
        }
        return dataType;
    }
}

