/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import com.lancedb.lance.spark.utils.VectorUtils;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;

public final class LanceArrowUtils$ {
    public static LanceArrowUtils$ MODULE$;
    private final String ARROW_FIXED_SIZE_LIST_SIZE_KEY;
    private final String ENCODING_BLOB;

    static {
        new LanceArrowUtils$();
    }

    public String ARROW_FIXED_SIZE_LIST_SIZE_KEY() {
        return this.ARROW_FIXED_SIZE_LIST_SIZE_KEY;
    }

    public String ENCODING_BLOB() {
        return this.ENCODING_BLOB;
    }

    public DataType fromArrowField(Field field) {
        ArrowType.Int intVal;
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Int && !(intVal = (ArrowType.Int)arrowType).getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FixedSizeList) {
            java.util.List children = field.getChildren();
            if (children.isEmpty()) {
                throw new SparkException(new StringBuilder(36).append("FixedSizeList field ").append(field.getName()).append(" has no children").toString());
            }
            Field elementField = (Field)children.get(0);
            DataType elementType = this.fromArrowField(elementField);
            boolean containsNull = elementField.isNullable();
            return new ArrayType(elementType, containsNull);
        }
        if (arrowType instanceof ArrowType.Struct) {
            if (this.isBlobField(field)) {
                StructField[] fields = (StructField[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable & scala.Serializable)childField -> {
                    ArrowType.Int intVal;
                    ArrowType arrowType = childField.getType();
                    DataType childType = arrowType instanceof ArrowType.Int && !(intVal = (ArrowType.Int)arrowType).getIsSigned() && intVal.getBitWidth() == 64 ? LongType$.MODULE$ : MODULE$.fromArrowField((Field)childField);
                    return new StructField(childField.getName(), childType, childField.isNullable(), StructField$.MODULE$.apply$default$4());
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
                return new StructType(fields);
            }
            return ArrowUtils$.MODULE$.fromArrowField(field);
        }
        if (arrowType instanceof ArrowType.LargeBinary && this.isBlobField(field)) {
            return BinaryType$.MODULE$;
        }
        return ArrowUtils$.MODULE$.fromArrowField(field);
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            Metadata metadata;
            DataType dt = MODULE$.fromArrowField((Field)field);
            ArrowType arrowType = field.getType();
            if (arrowType instanceof ArrowType.FixedSizeList) {
                ArrowType.FixedSizeList fixedSizeList = (ArrowType.FixedSizeList)arrowType;
                metadata = new MetadataBuilder().putLong(MODULE$.ARROW_FIXED_SIZE_LIST_SIZE_KEY(), (long)fixedSizeList.getListSize()).build();
            } else {
                metadata = Metadata$.MODULE$.fromJObject(new JsonAST.JObject(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(field.getMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return new Tuple2((Object)k, (Object)new JsonAST.JString(v));
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom())).toList()));
            }
            Metadata metadata2 = metadata;
            return new StructField(field.getName(), dt, field.isNullable(), metadata2);
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), MODULE$.deduplicateFieldNames(field.dataType(), errorOnDuplicatedFieldNames), field.nullable(), timeZoneId, largeVarTypes, field.metadata()), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public boolean toArrowSchema$default$4() {
        return false;
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId, boolean largeVarTypes, Metadata metadata) {
        DataType dataType;
        scala.collection.immutable.Map meta;
        BooleanRef large;
        while (true) {
            large = BooleanRef.create((boolean)largeVarTypes);
            meta = Predef$.MODULE$.Map().empty();
            if (metadata != null) {
                if (metadata.contains(this.ENCODING_BLOB()) && metadata.getString(this.ENCODING_BLOB()).equalsIgnoreCase("true")) {
                    large.elem = true;
                }
                DefaultFormats$ formats = DefaultFormats$.MODULE$;
                meta = (scala.collection.immutable.Map)package$.MODULE$.jvalue2extractable(metadata.jsonValue()).extract((Formats)formats, ManifestFactory$.MODULE$.classType(scala.collection.immutable.Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(String.class)})));
            }
            if ((dataType = dt) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (this.shouldBeFixedSizeList(metadata, elementType)) {
                    int listSize = (int)metadata.getLong(this.ARROW_FIXED_SIZE_LIST_SIZE_KEY());
                    FieldType fieldType = new FieldType(nullable, (ArrowType)new ArrowType.FixedSizeList(listSize), null, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava());
                    return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, large.elem, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
                }
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava());
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, large.elem, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava());
                return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId, large$1.elem, MODULE$.toArrowField$default$6()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava());
                return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", (DataType)new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            metadata = this.toArrowField$default$6();
            dt = userDefinedType.sqlType();
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId, large.elem, name), null, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)meta).asJava());
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
    }

    public boolean toArrowField$default$5() {
        return false;
    }

    public Metadata toArrowField$default$6() {
        return null;
    }

    private ArrowType toArrowType(DataType dt, String timeZoneId, boolean largeVarTypes, String name) {
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        boolean bl2 = false;
        StringType stringType = null;
        boolean bl3 = false;
        DataType dataType2 = null;
        boolean bl4 = false;
        DataType dataType3 = null;
        DataType dataType4 = dt;
        if (BooleanType$.MODULE$.equals(dataType4)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType4)) {
            bl = true;
            dataType = dataType4;
            if (name.equals("_rowid")) {
                return new ArrowType.Int(64, false);
            }
        }
        if (bl) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType4)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (dataType4 instanceof StringType) {
            bl2 = true;
            stringType = (StringType)dataType4;
            if (!largeVarTypes) {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        if (BinaryType$.MODULE$.equals(dataType4)) {
            bl3 = true;
            dataType2 = dataType4;
            if (!largeVarTypes) {
                return ArrowType.Binary.INSTANCE;
            }
        }
        if (bl2 && largeVarTypes) {
            return ArrowType.LargeUtf8.INSTANCE;
        }
        if (bl3 && largeVarTypes) {
            return ArrowType.LargeBinary.INSTANCE;
        }
        if (dataType4 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType4)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale, 128);
        }
        if (DateType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType4)) {
            bl4 = true;
            dataType3 = dataType4;
            if (timeZoneId == null) {
                throw SparkException$.MODULE$.internalError("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl4) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (NullType$.MODULE$.equals(dataType4)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType4 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType4 instanceof DayTimeIntervalType) {
            return new ArrowType.Duration(TimeUnit.MICROSECOND);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType4)) {
            return new ArrowType.Interval(IntervalUnit.MONTH_DAY_NANO);
        }
        throw this.unsupportedDataTypeError(dt);
    }

    private boolean toArrowType$default$3() {
        return false;
    }

    private DataType deduplicateFieldNames(DataType dt, boolean errorOnDuplicatedFieldNames) {
        DataType dataType;
        while ((dataType = dt) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof StructType) {
            String[] stringArray;
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).toSet().size() == structType.names().length) {
                stringArray = structType.names();
            } else {
                if (errorOnDuplicatedFieldNames) {
                    throw this.duplicatedFieldNameInArrowStructError((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])structType.names()));
                }
                scala.collection.immutable.Map genNawName = (scala.collection.immutable.Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String[] names = (String[])tuple2._2();
                        if (names.length > 1) {
                            AtomicInteger i = new AtomicInteger();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(name).append("_").append(i.getAndIncrement()).toString());
                        }
                    }
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable & scala.Serializable)() -> name);
                    }
                    throw new MatchError((Object)tuple2);
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.names())).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)((Function0)genNawName.apply(x$1)).apply(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] newNames = stringArray;
            StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])newNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    String name = (String)tuple2._2();
                    if (structField != null) {
                        DataType dataType = structField.dataType();
                        boolean nullable = structField.nullable();
                        Metadata metadata = structField.metadata();
                        return new StructField(name, MODULE$.deduplicateFieldNames(dataType, errorOnDuplicatedFieldNames), nullable, metadata);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            return new StructType(newFields);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return new ArrayType(this.deduplicateFieldNames(elementType, errorOnDuplicatedFieldNames), containsNull);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return new MapType(this.deduplicateFieldNames(keyType, errorOnDuplicatedFieldNames), this.deduplicateFieldNames(valueType, errorOnDuplicatedFieldNames), valueContainsNull);
        }
        return dt;
    }

    private boolean shouldBeFixedSizeList(Metadata metadata, DataType elementType) {
        return VectorUtils.shouldBeFixedSizeList((DataType)new ArrayType(elementType, true), metadata);
    }

    private SparkUnsupportedOperationException unsupportedDataTypeError(DataType typeName) {
        return new SparkUnsupportedOperationException("UNSUPPORTED_DATATYPE", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)new StringBuilder(2).append("\"").append(typeName.sql().toUpperCase(Locale.ROOT)).append("\"").toString())})));
    }

    private SparkUnsupportedOperationException duplicatedFieldNameInArrowStructError(Seq<String> fieldNames) {
        return new SparkUnsupportedOperationException("DUPLICATED_FIELD_NAME_IN_ARROW_STRUCT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)fieldNames.mkString("[", ", ", "]"))})));
    }

    private boolean isBlobField(Field field) {
        java.util.Map metadata = field.getMetadata();
        return metadata != null && metadata.containsKey(this.ENCODING_BLOB()) && "true".equalsIgnoreCase((String)metadata.get(this.ENCODING_BLOB()));
    }

    private LanceArrowUtils$() {
        MODULE$ = this;
        this.ARROW_FIXED_SIZE_LIST_SIZE_KEY = "arrow.fixed-size-list.size";
        this.ENCODING_BLOB = "lance-encoding:blob";
    }
}

