/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import scala.collection.Seq;

public abstract class BaseFixedSizeListSQLTest {
    @TempDir
    Path tempDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithFixedSizeListVectorSQL() {
        String catalogName = "lance_test";
        SparkSession spark = SparkSession.builder().appName("fixedsizelist-sql-test").master("local[*]").config("spark.sql.catalog." + catalogName, "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.catalog." + catalogName + ".impl", "dir").config("spark.sql.catalog." + catalogName + ".root", this.tempDir.toString()).getOrCreate();
        try {
            String tableName = "vector_table_sql";
            spark.sql("CREATE TABLE IF NOT EXISTS " + catalogName + ".default." + tableName + " (id INT NOT NULL, text STRING, embeddings ARRAY<FLOAT> NOT NULL) USING lance TBLPROPERTIES ('embeddings.arrow.fixed-size-list.size' = '128')");
            spark.sql("SHOW TABLES IN " + catalogName + ".default").show();
            StructType schema = spark.table(catalogName + ".default." + tableName).schema();
            Assertions.assertNotNull((Object)schema);
            Assertions.assertEquals((int)3, (int)schema.fields().length);
            StructField embeddingsField = schema.apply("embeddings");
            Assertions.assertNotNull((Object)embeddingsField);
            Metadata metadata = embeddingsField.metadata();
            if (metadata.contains("arrow.fixed-size-list.size")) {
                long size = metadata.getLong("arrow.fixed-size-list.size");
                Assertions.assertEquals((long)128L, (long)size);
            }
            spark.sql("INSERT INTO " + catalogName + ".default." + tableName + " VALUES (1, 'test_text', array(" + IntStream.range(0, 128).mapToObj(i -> String.valueOf((float)i * 0.01f)).collect(Collectors.joining(", ")) + "))");
            Dataset result = spark.sql("SELECT * FROM " + catalogName + ".default." + tableName);
            Assertions.assertEquals((long)1L, (long)result.count(), (String)"Should have 1 row");
            Row firstRow = (Row)result.first();
            Assertions.assertEquals((int)1, (int)firstRow.getInt(0));
            Assertions.assertEquals((Object)"test_text", (Object)firstRow.getString(1));
            Seq embeddings = firstRow.getSeq(2);
            Assertions.assertEquals((int)128, (int)embeddings.size(), (String)"Embeddings should have 128 elements");
            spark.sql("DROP TABLE IF EXISTS " + catalogName + ".default." + tableName);
        }
        finally {
            spark.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithMultipleVectorColumnsSQL() {
        String catalogName = "lance_test";
        SparkSession spark = SparkSession.builder().appName("multi-vector-sql-test").master("local[*]").config("spark.sql.catalog." + catalogName, "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.catalog." + catalogName + ".impl", "dir").config("spark.sql.catalog." + catalogName + ".root", this.tempDir.toString()).getOrCreate();
        try {
            int i;
            String tableName = "multi_vector_table_sql";
            spark.sql("CREATE TABLE IF NOT EXISTS " + catalogName + ".default." + tableName + " (id INT NOT NULL, title STRING, title_embeddings ARRAY<FLOAT> NOT NULL, content_embeddings ARRAY<FLOAT> NOT NULL, summary_embeddings ARRAY<FLOAT> NOT NULL) USING lance TBLPROPERTIES ('title_embeddings.arrow.fixed-size-list.size' = '64', 'content_embeddings.arrow.fixed-size-list.size' = '256', 'summary_embeddings.arrow.fixed-size-list.size' = '128')");
            StructType schema = spark.table(catalogName + ".default." + tableName).schema();
            Assertions.assertNotNull((Object)schema);
            Assertions.assertEquals((int)5, (int)schema.fields().length);
            StringBuilder insertSQL = new StringBuilder();
            insertSQL.append("INSERT INTO ").append(catalogName).append(".default.").append(tableName);
            insertSQL.append(" VALUES (1, 'doc1', ");
            insertSQL.append("array(");
            for (i = 0; i < 64; ++i) {
                if (i > 0) {
                    insertSQL.append(", ");
                }
                insertSQL.append((float)i * 0.01f);
            }
            insertSQL.append("), ");
            insertSQL.append("array(");
            for (i = 0; i < 256; ++i) {
                if (i > 0) {
                    insertSQL.append(", ");
                }
                insertSQL.append((float)i * 0.002f);
            }
            insertSQL.append("), ");
            insertSQL.append("array(");
            for (i = 0; i < 128; ++i) {
                if (i > 0) {
                    insertSQL.append(", ");
                }
                insertSQL.append((float)i * 0.005f);
            }
            insertSQL.append("))");
            spark.sql(insertSQL.toString());
            Dataset result = spark.sql("SELECT * FROM " + catalogName + ".default." + tableName);
            Assertions.assertEquals((long)1L, (long)result.count());
            spark.sql("DROP TABLE IF EXISTS " + catalogName + ".default." + tableName);
        }
        finally {
            spark.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixedPrecisionVectorsSQL() {
        String catalogName = "lance_test";
        SparkSession spark = SparkSession.builder().appName("mixed-precision-sql-test").master("local[*]").config("spark.sql.catalog." + catalogName, "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.catalog." + catalogName + ".impl", "dir").config("spark.sql.catalog." + catalogName + ".root", this.tempDir.toString()).getOrCreate();
        try {
            String tableName = "mixed_precision_sql";
            spark.sql("CREATE TABLE IF NOT EXISTS " + catalogName + ".default." + tableName + " (id INT NOT NULL, float_vec ARRAY<FLOAT> NOT NULL, double_vec ARRAY<DOUBLE> NOT NULL) USING lance TBLPROPERTIES ('float_vec.arrow.fixed-size-list.size' = '32', 'double_vec.arrow.fixed-size-list.size' = '32')");
            spark.sql("INSERT INTO " + catalogName + ".default." + tableName + " VALUES (1, array(" + IntStream.range(0, 32).mapToObj(i -> String.valueOf((float)i * 0.1f)).collect(Collectors.joining(", ")) + "), array(" + IntStream.range(0, 32).mapToObj(i -> String.valueOf((double)i * 0.01)).collect(Collectors.joining(", ")) + "))");
            Dataset result = spark.sql("SELECT * FROM " + catalogName + ".default." + tableName);
            Assertions.assertEquals((long)1L, (long)result.count());
            spark.sql("DROP TABLE IF EXISTS " + catalogName + ".default." + tableName);
        }
        finally {
            spark.stop();
        }
    }
}

