/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.namespace.hive3.LocalHive3Metastore;
import com.lancedb.lance.spark.SparkLanceNamespaceTestBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class BaseTestSparkHive3Namespace
extends SparkLanceNamespaceTestBase {
    private LocalHive3Metastore metastore;

    @Override
    @BeforeEach
    void setup() throws IOException {
        this.metastore = new LocalHive3Metastore();
        this.metastore.start();
        super.setup();
    }

    @Override
    @AfterEach
    void tearDown() throws IOException {
        super.tearDown();
        if (this.metastore != null) {
            try {
                this.metastore.stop();
            }
            catch (Exception e) {
                throw new IOException("Failed to stop Hive metastore", e);
            }
        }
    }

    @Override
    protected String getNsImpl() {
        return "hive3";
    }

    @Override
    protected Map<String, String> getAdditionalNsConfigs() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("parent", "hive");
        configs.put("parent_delimiter", ".");
        if (this.metastore != null && this.metastore.hiveConf() != null) {
            String metastoreUri = this.metastore.hiveConf().getVar(HiveConf.ConfVars.METASTOREURIS);
            configs.put("hadoop.hive.metastore.uris", metastoreUri);
        }
        configs.put("client.pool-size", "3");
        configs.put("root", this.tempDir.toString() + "/lance");
        return configs;
    }

    @Override
    protected boolean supportsNamespace() {
        return true;
    }
}

