/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class BaseVectorCreateTableTest {
    private SparkSession spark;
    private static final String catalogName = "lance_ns";
    @TempDir
    protected Path tempDir;

    @BeforeEach
    void setup() {
        this.spark = SparkSession.builder().appName("vector-create-table-test").master("local[*]").config("spark.sql.catalog.lance_ns", "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.catalog.lance_ns.impl", "dir").config("spark.sql.catalog.lance_ns.root", this.tempDir.toString()).getOrCreate();
    }

    @AfterEach
    void tearDown() {
        if (this.spark != null) {
            this.spark.stop();
        }
    }

    @Test
    public void testCreateEmptyTableWithVectorAndSQLInsert() {
        String tableName = "vector_empty_table_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, text STRING, embeddings ARRAY<FLOAT> NOT NULL) USING lance TBLPROPERTIES ('embeddings.arrow.fixed-size-list.size' = '128')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        this.spark.sql("INSERT INTO lance_ns.default." + tableName + " VALUES (1, 'first text', array(" + this.generateFloatArray(128) + ")), (2, 'second text', array(" + this.generateFloatArray(128) + "))");
        Dataset result = this.spark.sql("SELECT COUNT(*) FROM lance_ns.default." + tableName);
        Assertions.assertEquals((long)2L, (long)((Row)result.collectAsList().get(0)).getLong(0));
        Dataset projection = this.spark.sql("SELECT id, text FROM lance_ns.default." + tableName + " ORDER BY id");
        List rows = projection.collectAsList();
        Assertions.assertEquals((int)2, (int)rows.size());
        Assertions.assertEquals((int)1, (int)((Row)rows.get(0)).getInt(0));
        Assertions.assertEquals((Object)"first text", (Object)((Row)rows.get(0)).getString(1));
        Assertions.assertEquals((int)2, (int)((Row)rows.get(1)).getInt(0));
        Assertions.assertEquals((Object)"second text", (Object)((Row)rows.get(1)).getString(1));
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    private String generateFloatArray(int size) {
        Random random = new Random(42L);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(random.nextFloat());
        }
        return sb.toString();
    }

    @Test
    public void testCreateTableWithVectorColumnFloat32() {
        String tableName = "vector_table_float32_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, embeddings ARRAY<FLOAT> NOT NULL) USING lance TBLPROPERTIES ('embeddings.arrow.fixed-size-list.size' = '128')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        ArrayList<Row> rows = new ArrayList<Row>();
        Random random = new Random(42L);
        for (int i = 0; i < 10; ++i) {
            float[] vector = new float[128];
            for (int j = 0; j < 128; ++j) {
                vector[j] = random.nextFloat();
            }
            rows.add(RowFactory.create((Object[])new Object[]{i, vector}));
        }
        Metadata vectorMetadata = new MetadataBuilder().putLong("arrow.fixed-size-list.size", 128L).build();
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"embeddings", (DataType)DataTypes.createArrayType((DataType)DataTypes.FloatType, (boolean)false), (boolean)false, (Metadata)vectorMetadata)});
        Dataset df = this.spark.createDataFrame(rows, schema);
        try {
            df.writeTo("lance_ns.default." + tableName).append();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to append data to table: " + e.getMessage()));
        }
        Dataset result = this.spark.sql("SELECT COUNT(*) FROM lance_ns.default." + tableName);
        Assertions.assertEquals((long)10L, (long)((Row)result.collectAsList().get(0)).getLong(0));
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateTableWithVectorColumnFloat64() {
        String tableName = "vector_table_float64_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, embeddings ARRAY<DOUBLE> NOT NULL) USING lance TBLPROPERTIES ('embeddings.arrow.fixed-size-list.size' = '64')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        ArrayList<Row> rows = new ArrayList<Row>();
        Random random = new Random(42L);
        for (int i = 0; i < 10; ++i) {
            double[] vector = new double[64];
            for (int j = 0; j < 64; ++j) {
                vector[j] = random.nextDouble();
            }
            rows.add(RowFactory.create((Object[])new Object[]{i, vector}));
        }
        Metadata vectorMetadata = new MetadataBuilder().putLong("arrow.fixed-size-list.size", 64L).build();
        StructType schema = new StructType(new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"embeddings", (DataType)DataTypes.createArrayType((DataType)DataTypes.DoubleType, (boolean)false), (boolean)false, (Metadata)vectorMetadata)});
        Dataset df = this.spark.createDataFrame(rows, schema);
        try {
            df.writeTo("lance_ns.default." + tableName).append();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to append data to table: " + e.getMessage()));
        }
        Dataset result = this.spark.sql("SELECT COUNT(*) FROM lance_ns.default." + tableName);
        Assertions.assertEquals((long)10L, (long)((Row)result.collectAsList().get(0)).getLong(0));
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateTableWithMultipleVectorColumns() {
        String tableName = "vector_table_multi_" + System.currentTimeMillis();
        this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, embeddings1 ARRAY<FLOAT> NOT NULL, embeddings2 ARRAY<DOUBLE> NOT NULL) USING lance TBLPROPERTIES ('embeddings1.arrow.fixed-size-list.size' = '128', 'embeddings2.arrow.fixed-size-list.size' = '256')");
        Dataset tables = this.spark.sql("SHOW TABLES IN lance_ns.default");
        List tableList = tables.collectAsList();
        boolean found = tableList.stream().anyMatch(row -> tableName.equals(row.getString(1)));
        Assertions.assertTrue((boolean)found, (String)"Table should be created");
        this.spark.sql("DROP TABLE IF EXISTS lance_ns.default." + tableName);
    }

    @Test
    public void testCreateTableWithInvalidVectorType() {
        String tableName = "vector_table_invalid_" + System.currentTimeMillis();
        try {
            this.spark.sql("CREATE TABLE IF NOT EXISTS lance_ns.default." + tableName + " (id INT NOT NULL, embeddings ARRAY<INT> NOT NULL) USING lance TBLPROPERTIES ('embeddings.arrow.fixed-size-list.size' = '128')");
            Assertions.fail((String)"Should throw exception for non-float/double vector column");
        }
        catch (Exception e) {
            Assertions.assertTrue((e.getMessage().contains("must have element type FLOAT or DOUBLE") || e.getCause().getMessage().contains("must have element type FLOAT or DOUBLE") ? 1 : 0) != 0);
        }
    }
}

