/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.read.FilterPushDown;
import com.lancedb.lance.spark.utils.Optional;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterPushDownTest {
    @Test
    public void testCompileFiltersToSqlWhereClause() {
        Filter[] filters1 = new Filter[]{new GreaterThan("age", (Object)30), new LessThanOrEqual("salary", (Object)100000), new IsNotNull("name")};
        Optional whereClause1 = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters1);
        Assertions.assertTrue((boolean)whereClause1.isPresent());
        Assertions.assertEquals((Object)"(age > 30) AND (salary <= 100000) AND (name IS NOT NULL)", (Object)whereClause1.get());
        Filter[] filters2 = new Filter[]{new GreaterThan("age", (Object)30), new StringContains("name", "John"), new LessThan("salary", (Object)50000)};
        Optional whereClause2 = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters2);
        Assertions.assertTrue((boolean)whereClause2.isPresent());
        Assertions.assertEquals((Object)"(age > 30) AND (salary < 50000)", (Object)whereClause2.get());
        Filter[] filters3 = new Filter[]{};
        Optional whereClause3 = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters3);
        Assertions.assertFalse((boolean)whereClause3.isPresent());
        Filter[] filters4 = new Filter[]{new GreaterThan("age", (Object)30), new StringContains("name", "John"), new IsNull("address"), new EqualTo("country", (Object)"USA")};
        Optional whereClause4 = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters4);
        Assertions.assertTrue((boolean)whereClause4.isPresent());
        Assertions.assertEquals((Object)"(age > 30) AND (address IS NULL) AND (country == 'USA')", (Object)whereClause4.get());
        Filter[] filters5 = new Filter[]{new Not((Filter)new GreaterThan("age", (Object)30)), new Or((Filter)new IsNotNull("name"), (Filter)new IsNull("address")), new And((Filter)new LessThan("salary", (Object)100000), (Filter)new GreaterThanOrEqual("salary", (Object)50000))};
        Optional whereClause5 = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters5);
        Assertions.assertTrue((boolean)whereClause5.isPresent());
        Assertions.assertEquals((Object)"(NOT (age > 30)) AND ((name IS NOT NULL) OR (address IS NULL)) AND ((salary < 100000) AND (salary >= 50000))", (Object)whereClause5.get());
    }

    @Test
    public void testCompileFiltersToSqlWhereClauseWithEmptyFilters() {
        Filter[] filters = new Filter[]{};
        Optional whereClause = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters);
        Assertions.assertFalse((boolean)whereClause.isPresent());
    }

    @Test
    public void testIntegerInFilterPushDown() {
        Object[] values = new Object[]{500, 600};
        Filter[] filters = new Filter[]{new GreaterThan("age", (Object)30), new In("salary", values)};
        Optional whereClause = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters);
        Assertions.assertTrue((boolean)whereClause.isPresent());
        Assertions.assertEquals((Object)"(age > 30) AND (salary IN (500,600))", (Object)whereClause.get());
    }

    @Test
    public void testStringInFilterPushDown() {
        Object[] values = new Object[]{"500", "600"};
        Filter[] filters = new Filter[]{new GreaterThan("age", (Object)30), new In("salary", values)};
        Optional whereClause = FilterPushDown.compileFiltersToSqlWhereClause((Filter[])filters);
        Assertions.assertTrue((boolean)whereClause.isPresent());
        Assertions.assertEquals((Object)"(age > 30) AND (salary IN ('500','600'))", (Object)whereClause.get());
    }
}

