/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.update;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class BaseAddColumnsBackfillTest {
    protected String catalogName = "lance_test";
    protected String tableName = "add_column_backfill";
    protected String fullTable = this.catalogName + ".default." + this.tableName;
    protected SparkSession spark;
    @TempDir
    Path tempDir;

    @BeforeEach
    public void setup() throws IOException {
        this.spark = SparkSession.builder().appName("dataframe-addcolumn-test").master("local[12]").config("spark.sql.catalog." + this.catalogName, "com.lancedb.lance.spark.LanceNamespaceSparkCatalog").config("spark.sql.extensions", "com.lancedb.lance.spark.extensions.LanceSparkSessionExtensions").config("spark.sql.catalog." + this.catalogName + ".impl", "dir").config("spark.sql.catalog." + this.catalogName + ".root", this.tempDir.toString()).getOrCreate();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.spark != null) {
            this.spark.close();
        }
    }

    protected void prepareDataset() {
        this.spark.sql(String.format("create table %s (id int, text string) using lance;", this.fullTable));
        this.spark.sql(String.format("insert into %s (id, text) values %s ;", this.fullTable, IntStream.range(0, 10).boxed().map(i -> String.format("(%d, 'text_%d')", i, i)).collect(Collectors.joining(","))));
    }

    @Test
    public void testWithDataFrame() {
        this.prepareDataset();
        Dataset result = this.spark.table(this.fullTable);
        Assertions.assertEquals((long)10L, (long)result.count(), (String)"Should have 10 rows");
        result = result.select("_rowaddr", new String[]{"_fragid", "id"});
        Dataset df2 = result.withColumn("new_col1", functions.expr((String)"id * 100")).withColumn("new_col2", functions.expr((String)"id * 2"));
        df2.createOrReplaceTempView("tmp_view");
        this.spark.sql(String.format("alter table %s add columns new_col1, new_col2 from tmp_view", this.fullTable));
        Assertions.assertEquals((Object)"[[0,0,0,text_0], [1,100,2,text_1], [2,200,4,text_2], [3,300,6,text_3], [4,400,8,text_4], [5,500,10,text_5], [6,600,12,text_6], [7,700,14,text_7], [8,800,16,text_8], [9,900,18,text_9]]", (Object)this.spark.table(this.fullTable).select("id", new String[]{"new_col1", "new_col2", "text"}).collectAsList().toString());
    }

    @Test
    public void testWithSql() {
        this.prepareDataset();
        this.spark.sql(String.format("create temporary view tmp_view as select _rowaddr, _fragid, id * 100 as new_col1, id * 2 as new_col2, id * 3 as new_col3 from %s;", this.fullTable));
        this.spark.sql(String.format("alter table %s add columns new_col1, new_col2 from tmp_view", this.fullTable));
        Assertions.assertEquals((Object)"[[0,0,0,text_0], [1,100,2,text_1], [2,200,4,text_2], [3,300,6,text_3], [4,400,8,text_4], [5,500,10,text_5], [6,600,12,text_6], [7,700,14,text_7], [8,800,16,text_8], [9,900,18,text_9]]", (Object)this.spark.sql(String.format("select id, new_col1, new_col2, text from %s", this.fullTable)).collectAsList().toString());
    }

    @Test
    public void testAddExistedColumns() {
        this.prepareDataset();
        this.spark.sql(String.format("create temporary view tmp_view as select _rowaddr, _fragid, id * 100 as id, id * 2 as new_col2 from %s;", this.fullTable));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.spark.sql(String.format("alter table %s add columns id, new_col2 from tmp_view", this.fullTable)), (String)"Can't add existed columns: id");
    }

    @Test
    public void testAddRowsNotAligned() {
        this.prepareDataset();
        this.spark.sql(String.format("create temporary view tmp_view as select _rowaddr, _fragid, concat('new_col_1_', id) as new_col1 from %s where id in (0, 1, 4, 8, 9);", this.fullTable));
        this.spark.sql(String.format("alter table %s add columns new_col1 from tmp_view", this.fullTable));
        Assertions.assertEquals((Object)"[[0,new_col_1_0,text_0], [1,new_col_1_1,text_1], [2,null,text_2], [3,null,text_3], [4,new_col_1_4,text_4], [5,null,text_5], [6,null,text_6], [7,null,text_7], [8,new_col_1_8,text_8], [9,new_col_1_9,text_9]]", (Object)this.spark.sql(String.format("select id, new_col1, text from %s", this.fullTable)).collectAsList().toString());
    }
}

