/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaces;
import com.lancedb.lance.namespace.ListTablesIterable;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.util.PropertyUtil;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.LanceDataset;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.utils.Optional;
import com.lancedb.lance.spark.utils.SchemaConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class LanceNamespaceSparkCatalog
implements TableCatalog {
    private static final Logger logger = Logger.getLogger(LanceNamespaceSparkCatalog.class.getName());
    private static final String CONFIG_IMPL = "impl";
    private static final String CONFIG_EXTRA_LEVEL = "extra_level";
    private static final String CREATE_TABLE_PROPERTY_LOCATION = "location";
    private LanceNamespace namespace;
    private String name;
    private Optional<String> extraLevel;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        this.name = name;
        if (!options.containsKey((Object)CONFIG_IMPL)) {
            throw new IllegalArgumentException("Missing required configuration: impl");
        }
        String impl = PropertyUtil.propertyAsString((Map)options, (String)CONFIG_IMPL);
        this.namespace = LanceNamespaces.connect((String)impl, (Map)options, null, (BufferAllocator)LanceDatasetAdapter.allocator);
        this.extraLevel = options.containsKey((Object)CONFIG_EXTRA_LEVEL) ? Optional.of(PropertyUtil.propertyAsString((Map)options, (String)CONFIG_EXTRA_LEVEL)) : ("dir".equals(impl) ? Optional.of("default") : ("rest".equals(impl) ? this.determineExtraLevelForRest() : Optional.empty()));
    }

    public String name() {
        return this.name;
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        String[] actualNamespace = this.removeExtraLevelsFromNamespace(namespace);
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Arrays.stream(actualNamespace).collect(Collectors.toList()));
        ListTablesIterable tables = new ListTablesIterable(this.namespace, request);
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (String table : tables) {
            identifiers.add(Identifier.of((String[])namespace, (String)table));
        }
        return identifiers.toArray(new Identifier[0]);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        Identifier actualIdent = this.removeExtraLevelsFromId(ident);
        DescribeTableRequest request = new DescribeTableRequest();
        for (String part : actualIdent.namespace()) {
            request.addIdItem(part);
        }
        request.addIdItem(actualIdent.name());
        try {
            DescribeTableResponse response = this.namespace.describeTable(request);
            String location = response.getLocation();
            if (location == null || location.isEmpty()) {
                throw new NoSuchTableException(ident);
            }
            LanceConfig config = LanceConfig.from(location);
            Optional<StructType> schema = LanceDatasetAdapter.getSchema(config);
            if (!schema.isPresent()) {
                throw new NoSuchTableException(ident);
            }
            return new LanceDataset(config, schema.get());
        }
        catch (Exception e) {
            throw new NoSuchTableException(ident);
        }
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        Identifier tableId = this.removeExtraLevelsFromId(ident);
        CreateTableRequest createRequest = new CreateTableRequest();
        for (String part : tableId.namespace()) {
            createRequest.addIdItem(part);
        }
        createRequest.addIdItem(tableId.name());
        if (properties != null && properties.containsKey(CREATE_TABLE_PROPERTY_LOCATION)) {
            createRequest.setLocation(properties.get(CREATE_TABLE_PROPERTY_LOCATION));
        }
        if (properties != null && !properties.isEmpty()) {
            createRequest.setProperties(properties);
        }
        JsonArrowSchema jsonSchema = SchemaConverter.toJsonArrowSchema(schema);
        createRequest.setSchema(jsonSchema);
        byte[] emptyArrowData = this.createEmptyArrowIpcStream(jsonSchema);
        CreateTableResponse response = this.namespace.createTable(createRequest, emptyArrowData);
        LanceConfig config = LanceConfig.from(response.getLocation());
        return new LanceDataset(config, schema);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        throw new UnsupportedOperationException("Table alteration is not supported");
    }

    public boolean dropTable(Identifier ident) {
        try {
            Identifier tableId = this.removeExtraLevelsFromId(ident);
            DropTableRequest dropRequest = new DropTableRequest();
            for (String part : tableId.namespace()) {
                dropRequest.addIdItem(part);
            }
            dropRequest.addIdItem(tableId.name());
            this.namespace.dropTable(dropRequest);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("Table renaming is not supported");
    }

    private Identifier removeExtraLevelsFromId(Identifier identifier) {
        if (this.extraLevel.isEmpty()) {
            return identifier;
        }
        String[] newNamespace = this.removeExtraLevelsFromNamespace(identifier.namespace());
        return Identifier.of((String[])newNamespace, (String)identifier.name());
    }

    private String[] removeExtraLevelsFromNamespace(String[] namespace) {
        if (this.extraLevel.isEmpty()) {
            return namespace;
        }
        String extraLevelName = this.extraLevel.get();
        if (namespace.length > 0 && extraLevelName.equals(namespace[0])) {
            String[] newNamespace = new String[namespace.length - 1];
            System.arraycopy(namespace, 1, newNamespace, 0, namespace.length - 1);
            return newNamespace;
        }
        return namespace;
    }

    /*
     * Exception decompiling
     */
    private byte[] createEmptyArrowIpcStream(JsonArrowSchema jsonSchema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<String> determineExtraLevelForRest() {
        try {
            ListNamespacesRequest request = new ListNamespacesRequest();
            this.namespace.listNamespaces(request);
            return Optional.empty();
        }
        catch (Exception e) {
            logger.info("REST namespace ListNamespaces failed, falling back to flat table structure with extra_level=default");
            return Optional.of("default");
        }
    }
}

