/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.write;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.write.LanceBatchWrite;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.SupportsTruncate;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.types.StructType;

public class SparkWrite
implements Write {
    private final LanceConfig config;
    private final StructType schema;
    private final boolean overwrite;

    SparkWrite(StructType schema, LanceConfig config, boolean overwrite) {
        this.schema = schema;
        this.config = config;
        this.overwrite = overwrite;
    }

    public BatchWrite toBatch() {
        return new LanceBatchWrite(this.schema, this.config, this.overwrite);
    }

    public StreamingWrite toStreaming() {
        throw new UnsupportedOperationException();
    }

    public static class SparkWriteBuilder
    implements SupportsTruncate,
    WriteBuilder {
        private final LanceConfig config;
        private final StructType schema;
        private boolean overwrite = false;

        public SparkWriteBuilder(StructType schema, LanceConfig config) {
            this.schema = schema;
            this.config = config;
        }

        public Write build() {
            return new SparkWrite(this.schema, this.config, this.overwrite);
        }

        public WriteBuilder truncate() {
            this.overwrite = true;
            return this;
        }
    }
}

