/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.utils;

import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;
import scala.collection.immutable.Map;

public class SparkUtil {
    private static final String SPARK_CATALOG_CONF_PREFIX = "spark.sql.catalog";
    private static final String SPARK_CATALOG_HADOOP_CONF_OVERRIDE_FMT_STR = "spark.sql.catalog.%s.hadoop.";

    public static Configuration hadoopConfCatalogOverrides(SparkSession spark, String catalogName) {
        String hadoopConfCatalogPrefix = SparkUtil.hadoopConfPrefixForCatalog(catalogName);
        Configuration conf = spark.sessionState().newHadoopConf();
        Map allConfs = spark.conf().getAll();
        for (Tuple2 entry : allConfs) {
            String k = (String)entry._1();
            String v = (String)entry._2();
            if (v == null || k == null || !k.startsWith(hadoopConfCatalogPrefix)) continue;
            conf.set(k.substring(hadoopConfCatalogPrefix.length()), v);
        }
        return conf;
    }

    private static String hadoopConfPrefixForCatalog(String catalogName) {
        return String.format(SPARK_CATALOG_HADOOP_CONF_OVERRIDE_FMT_STR, catalogName);
    }
}

