/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.ipc.ColumnOrdering;
import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.read.LanceColumnarPartitionReader;
import com.lancedb.lance.spark.read.LanceCountStarPartitionReader;
import com.lancedb.lance.spark.read.LanceInputPartition;
import com.lancedb.lance.spark.read.LanceRowPartitionReader;
import com.lancedb.lance.spark.read.LanceSplit;
import com.lancedb.lance.spark.read.LanceStatistics;
import com.lancedb.lance.spark.utils.Optional;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.arrow.util.Preconditions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.internal.connector.SupportsMetadata;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public class LanceScan
implements Batch,
Scan,
SupportsMetadata,
SupportsReportStatistics,
Serializable {
    private static final long serialVersionUID = 947284762748623947L;
    private final StructType schema;
    private final LanceConfig config;
    private final Optional<String> whereConditions;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<List<ColumnOrdering>> topNSortOrders;
    private final Optional<Aggregation> pushedAggregation;
    private final String scanId = UUID.randomUUID().toString();

    public LanceScan(StructType schema, LanceConfig config, Optional<String> whereConditions, Optional<Integer> limit, Optional<Integer> offset, Optional<List<ColumnOrdering>> topNSortOrders, Optional<Aggregation> pushedAggregation) {
        this.schema = schema;
        this.config = config;
        this.whereConditions = whereConditions;
        this.limit = limit;
        this.offset = offset;
        this.topNSortOrders = topNSortOrders;
        this.pushedAggregation = pushedAggregation;
    }

    public Batch toBatch() {
        return this;
    }

    public InputPartition[] planInputPartitions() {
        List<LanceSplit> splits = LanceSplit.generateLanceSplits(this.config);
        return (InputPartition[])IntStream.range(0, splits.size()).mapToObj(i -> new LanceInputPartition(this.schema, i, (LanceSplit)splits.get(i), this.config, this.whereConditions, this.limit, this.offset, this.topNSortOrders, this.pushedAggregation, this.scanId)).toArray(InputPartition[]::new);
    }

    public PartitionReaderFactory createReaderFactory() {
        return new LanceReaderFactory();
    }

    public StructType readSchema() {
        if (this.pushedAggregation.isPresent()) {
            return new StructType().add("count", DataTypes.LongType);
        }
        return this.schema;
    }

    public Map<String, String> getMetaData() {
        Map empty;
        Map result = empty = Map$.MODULE$.empty();
        result = (Map)result.$plus(Tuple2.apply((Object)"whereConditions", (Object)this.whereConditions.toString()));
        result = (Map)result.$plus(Tuple2.apply((Object)"limit", (Object)this.limit.toString()));
        result = (Map)result.$plus(Tuple2.apply((Object)"offset", (Object)this.offset.toString()));
        result = (Map)result.$plus(Tuple2.apply((Object)"topNSortOrders", (Object)this.topNSortOrders.toString()));
        result = (Map)result.$plus(Tuple2.apply((Object)"pushedAggregation", (Object)this.pushedAggregation.toString()));
        return result;
    }

    public Statistics estimateStatistics() {
        return new LanceStatistics(this.config);
    }

    private static class LanceReaderFactory
    implements PartitionReaderFactory {
        private LanceReaderFactory() {
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            Preconditions.checkArgument((boolean)(partition instanceof LanceInputPartition), (Object)"Unknown InputPartition type. Expecting LanceInputPartition");
            return LanceRowPartitionReader.create((LanceInputPartition)partition);
        }

        public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
            AggregateFunc[] aggFunc;
            Preconditions.checkArgument((boolean)(partition instanceof LanceInputPartition), (Object)"Unknown InputPartition type. Expecting LanceInputPartition");
            LanceInputPartition lancePartition = (LanceInputPartition)partition;
            if (lancePartition.getPushedAggregation().isPresent() && (aggFunc = lancePartition.getPushedAggregation().get().aggregateExpressions()).length == 1 && aggFunc[0] instanceof CountStar) {
                return new LanceCountStarPartitionReader(lancePartition);
            }
            return new LanceColumnarPartitionReader(lancePartition);
        }

        public boolean supportColumnarReads(InputPartition partition) {
            return true;
        }
    }
}

