/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class LanceConfig
implements Serializable {
    private static final long serialVersionUID = 827364827364823764L;
    public static final String CONFIG_DATASET_URI = "path";
    public static final String CONFIG_PUSH_DOWN_FILTERS = "pushDownFilters";
    public static final String LANCE_FILE_SUFFIX = ".lance";
    private static final boolean DEFAULT_PUSH_DOWN_FILTERS = true;
    private final String dbPath;
    private final String datasetName;
    private final String datasetUri;
    private final boolean pushDownFilters;
    private final Map<String, String> options;

    private LanceConfig(String dbPath, String datasetName, String datasetUri, boolean pushDownFilters, CaseInsensitiveStringMap options) {
        this.dbPath = dbPath;
        this.datasetName = datasetName;
        this.datasetUri = datasetUri;
        this.pushDownFilters = pushDownFilters;
        this.options = options.asCaseSensitiveMap();
    }

    public static LanceConfig from(Map<String, String> properties) {
        return LanceConfig.from(new CaseInsensitiveStringMap(properties));
    }

    public static LanceConfig from(CaseInsensitiveStringMap options) {
        if (!options.containsKey((Object)CONFIG_DATASET_URI)) {
            throw new IllegalArgumentException("Missing required option path");
        }
        return LanceConfig.from(options, options.get((Object)CONFIG_DATASET_URI));
    }

    public static LanceConfig from(Map<String, String> properties, String datasetUri) {
        return LanceConfig.from(new CaseInsensitiveStringMap(properties), datasetUri);
    }

    public static LanceConfig from(String datasetUri) {
        return LanceConfig.from(CaseInsensitiveStringMap.empty(), datasetUri);
    }

    public static LanceConfig from(CaseInsensitiveStringMap options, String datasetUri) {
        boolean pushDownFilters = options.getBoolean(CONFIG_PUSH_DOWN_FILTERS, true);
        String[] paths = LanceConfig.extractDbPathAndDatasetName(datasetUri);
        return new LanceConfig(paths[0], paths[1], datasetUri, pushDownFilters, options);
    }

    private static String[] extractDbPathAndDatasetName(String datasetUri) {
        if (datasetUri == null) {
            throw new IllegalArgumentException("The dataset uri should not be null");
        }
        int lastSlashIndex = datasetUri.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            throw new IllegalArgumentException("Invalid dataset uri: " + datasetUri);
        }
        String dbPath = datasetUri.substring(0, lastSlashIndex + 1);
        String datasetNameWithSuffix = datasetUri.substring(lastSlashIndex + 1);
        String datasetName = datasetUri.endsWith(LANCE_FILE_SUFFIX) ? datasetNameWithSuffix.substring(0, datasetNameWithSuffix.length() - LANCE_FILE_SUFFIX.length()) : datasetNameWithSuffix;
        return new String[]{dbPath, datasetName};
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDatasetUri() {
        return this.datasetUri;
    }

    public boolean isPushDownFilters() {
        return this.pushDownFilters;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanceConfig config = (LanceConfig)o;
        return this.pushDownFilters == config.pushDownFilters && Objects.equals(this.dbPath, config.dbPath) && Objects.equals(this.datasetName, config.datasetName) && Objects.equals(this.datasetUri, config.datasetUri) && Objects.equals(this.options, config.options);
    }

    public int hashCode() {
        return Objects.hash(this.dbPath, this.datasetName, this.datasetUri, this.pushDownFilters, this.options);
    }
}

