/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.internal;

import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.internal.LanceFragmentScanner;
import com.lancedb.lance.spark.read.LanceInputPartition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.BlobStructAccessor;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.LanceArrowColumnVector;
import org.apache.spark.unsafe.types.UTF8String;

public class LanceFragmentColumnarBatchScanner
implements AutoCloseable {
    private final LanceFragmentScanner fragmentScanner;
    private final ArrowReader arrowReader;
    private ColumnarBatch currentColumnarBatch;

    public LanceFragmentColumnarBatchScanner(LanceFragmentScanner fragmentScanner, ArrowReader arrowReader) {
        this.fragmentScanner = fragmentScanner;
        this.arrowReader = arrowReader;
    }

    public static LanceFragmentColumnarBatchScanner create(int fragmentId, LanceInputPartition inputPartition) {
        LanceFragmentScanner fragmentScanner = LanceDatasetAdapter.getFragmentScanner(fragmentId, inputPartition);
        return new LanceFragmentColumnarBatchScanner(fragmentScanner, fragmentScanner.getArrowReader());
    }

    public boolean loadNextBatch() throws IOException {
        if (this.arrowReader.loadNextBatch()) {
            VectorSchemaRoot root = this.arrowReader.getVectorSchemaRoot();
            List<ColumnVector> fieldVectors = root.getFieldVectors().stream().map(LanceArrowColumnVector::new).collect(Collectors.toList());
            this.addBlobVirtualColumns(fieldVectors, root, this.fragmentScanner.getInputPartition());
            if (this.fragmentScanner.withFragemtId()) {
                ConstantColumnVector fragmentVector = new ConstantColumnVector(root.getRowCount(), DataTypes.IntegerType);
                fragmentVector.setInt(this.fragmentScanner.fragmentId());
                fieldVectors.add((ColumnVector)fragmentVector);
            }
            this.currentColumnarBatch = new ColumnarBatch(fieldVectors.toArray(new ColumnVector[0]), root.getRowCount());
            return true;
        }
        return false;
    }

    public ColumnarBatch getCurrentBatch() {
        return this.currentColumnarBatch;
    }

    @Override
    public void close() throws IOException {
        if (this.currentColumnarBatch != null) {
            this.currentColumnarBatch.close();
        }
        if (this.currentColumnarBatch != null) {
            this.currentColumnarBatch.close();
        }
        this.arrowReader.close();
        this.fragmentScanner.close();
    }

    private void addBlobVirtualColumns(List<ColumnVector> fieldVectors, VectorSchemaRoot root, LanceInputPartition inputPartition) {
        StructField[] fields;
        StructType schema = inputPartition.getSchema();
        HashMap<String, FieldVector> actualFields = new HashMap<String, FieldVector>();
        List rootVectors = root.getFieldVectors();
        for (int i = 0; i < rootVectors.size(); ++i) {
            actualFields.put(((FieldVector)rootVectors.get(i)).getField().getName(), (FieldVector)rootVectors.get(i));
        }
        for (StructField field : fields = schema.fields()) {
            FieldVector blobVector;
            String baseName;
            String fieldName = field.name();
            if (fieldName.endsWith("__blob_pos")) {
                baseName = fieldName.substring(0, fieldName.length() - "__blob_pos".length());
                blobVector = (FieldVector)actualFields.get(baseName);
                if (!(blobVector instanceof StructVector)) continue;
                BlobPositionColumnVector posVector = new BlobPositionColumnVector((StructVector)blobVector);
                fieldVectors.add(posVector);
                continue;
            }
            if (!fieldName.endsWith("__blob_size") || !((blobVector = (FieldVector)actualFields.get(baseName = fieldName.substring(0, fieldName.length() - "__blob_size".length()))) instanceof StructVector)) continue;
            BlobSizeColumnVector sizeVector = new BlobSizeColumnVector((StructVector)blobVector);
            fieldVectors.add(sizeVector);
        }
    }

    private static class BlobPositionColumnVector
    extends ColumnVector {
        private final BlobStructAccessor accessor;

        BlobPositionColumnVector(StructVector blobStruct) {
            super(DataTypes.LongType);
            this.accessor = new BlobStructAccessor(blobStruct);
        }

        public void close() {
            try {
                this.accessor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean hasNull() {
            return this.accessor.getNullCount() > 0;
        }

        public int numNulls() {
            return this.accessor.getNullCount();
        }

        public boolean isNullAt(int rowId) {
            return this.accessor.isNullAt(rowId);
        }

        public boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException("Blob position is not boolean");
        }

        public byte getByte(int rowId) {
            throw new UnsupportedOperationException("Blob position is not byte");
        }

        public short getShort(int rowId) {
            throw new UnsupportedOperationException("Blob position is not short");
        }

        public int getInt(int rowId) {
            return (int)this.getLong(rowId);
        }

        public long getLong(int rowId) {
            Long position = this.accessor.getPosition(rowId);
            return position != null ? position : 0L;
        }

        public float getFloat(int rowId) {
            throw new UnsupportedOperationException("Blob position is not float");
        }

        public double getDouble(int rowId) {
            throw new UnsupportedOperationException("Blob position is not double");
        }

        public Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException("Blob position is not decimal");
        }

        public UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException("Blob position is not string");
        }

        public byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException("Blob position is not binary");
        }

        public ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException("Blob position is not array");
        }

        public ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException("Blob position is not map");
        }

        public ColumnVector getChild(int ordinal) {
            throw new UnsupportedOperationException("Blob position column does not have children");
        }
    }

    private static class BlobSizeColumnVector
    extends ColumnVector {
        private final BlobStructAccessor accessor;

        BlobSizeColumnVector(StructVector blobStruct) {
            super(DataTypes.LongType);
            this.accessor = new BlobStructAccessor(blobStruct);
        }

        public void close() {
            try {
                this.accessor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean hasNull() {
            return this.accessor.getNullCount() > 0;
        }

        public int numNulls() {
            return this.accessor.getNullCount();
        }

        public boolean isNullAt(int rowId) {
            return this.accessor.isNullAt(rowId);
        }

        public boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException("Blob size is not boolean");
        }

        public byte getByte(int rowId) {
            throw new UnsupportedOperationException("Blob size is not byte");
        }

        public short getShort(int rowId) {
            throw new UnsupportedOperationException("Blob size is not short");
        }

        public int getInt(int rowId) {
            return (int)this.getLong(rowId);
        }

        public long getLong(int rowId) {
            Long size = this.accessor.getSize(rowId);
            return size != null ? size : 0L;
        }

        public float getFloat(int rowId) {
            throw new UnsupportedOperationException("Blob size is not float");
        }

        public double getDouble(int rowId) {
            throw new UnsupportedOperationException("Blob size is not double");
        }

        public Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException("Blob size is not decimal");
        }

        public UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException("Blob size is not string");
        }

        public byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException("Blob size is not binary");
        }

        public ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException("Blob size is not array");
        }

        public ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException("Blob size is not map");
        }

        public ColumnVector getChild(int ordinal) {
            throw new UnsupportedOperationException("Blob size column does not have children");
        }
    }
}

