/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.utils.Optional;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;

public class FilterPushDown {
    public static Optional<String> compileFiltersToSqlWhereClause(Filter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        ArrayList compiledFilters = new ArrayList();
        for (Filter filter2 : filters) {
            FilterPushDown.compileFilter(filter2).ifPresent(compiledFilters::add);
        }
        String whereClause = compiledFilters.stream().map(filter -> "(" + filter + ")").collect(Collectors.joining(" AND "));
        return Optional.of(whereClause);
    }

    public static Filter[][] processFilters(Filter[] filters) {
        ArrayList<Filter> acceptedFilters = new ArrayList<Filter>();
        ArrayList<Filter> rejectedFilters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            if (FilterPushDown.isFilterSupported(filter)) {
                acceptedFilters.add(filter);
                continue;
            }
            rejectedFilters.add(filter);
        }
        Filter[] acceptedArray = acceptedFilters.toArray(new Filter[0]);
        Filter[] rejectedArray = rejectedFilters.toArray(new Filter[0]);
        return new Filter[][]{acceptedArray, rejectedArray};
    }

    public static boolean isFilterSupported(Filter filter) {
        if (filter instanceof EqualTo) {
            return true;
        }
        if (filter instanceof EqualNullSafe) {
            return false;
        }
        if (filter instanceof In) {
            return true;
        }
        if (filter instanceof LessThan) {
            return true;
        }
        if (filter instanceof LessThanOrEqual) {
            return true;
        }
        if (filter instanceof GreaterThan) {
            return true;
        }
        if (filter instanceof GreaterThanOrEqual) {
            return true;
        }
        if (filter instanceof IsNull) {
            return true;
        }
        if (filter instanceof IsNotNull) {
            return true;
        }
        if (filter instanceof StringStartsWith) {
            return false;
        }
        if (filter instanceof StringEndsWith) {
            return false;
        }
        if (filter instanceof StringContains) {
            return false;
        }
        if (filter instanceof Not) {
            Not f = (Not)filter;
            return FilterPushDown.isFilterSupported(f.child());
        }
        if (filter instanceof Or) {
            Or f = (Or)filter;
            return FilterPushDown.isFilterSupported(f.left()) && FilterPushDown.isFilterSupported(f.right());
        }
        if (filter instanceof And) {
            And f = (And)filter;
            return FilterPushDown.isFilterSupported(f.left()) && FilterPushDown.isFilterSupported(f.right());
        }
        return false;
    }

    private static Optional<String> compileFilter(Filter filter) {
        if (filter instanceof GreaterThan) {
            GreaterThan f = (GreaterThan)filter;
            return Optional.of(f.attribute() + " > " + FilterPushDown.compileValue(f.value()));
        }
        if (filter instanceof LessThan) {
            LessThan f = (LessThan)filter;
            return Optional.of(f.attribute() + " < " + FilterPushDown.compileValue(f.value()));
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual f = (LessThanOrEqual)filter;
            return Optional.of(f.attribute() + " <= " + FilterPushDown.compileValue(f.value()));
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual f = (GreaterThanOrEqual)filter;
            return Optional.of(f.attribute() + " >= " + FilterPushDown.compileValue(f.value()));
        }
        if (filter instanceof EqualTo) {
            EqualTo f = (EqualTo)filter;
            return Optional.of(f.attribute() + " == " + FilterPushDown.compileValue(f.value()));
        }
        if (filter instanceof Or) {
            Or f = (Or)filter;
            Optional<String> left = FilterPushDown.compileFilter(f.left());
            Optional<String> right = FilterPushDown.compileFilter(f.right());
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            return Optional.of(String.format("(%s) OR (%s)", left.get(), right.get()));
        }
        if (filter instanceof And) {
            And f = (And)filter;
            Optional<String> left = FilterPushDown.compileFilter(f.left());
            Optional<String> right = FilterPushDown.compileFilter(f.right());
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            return Optional.of(String.format("(%s) AND (%s)", left.get(), right.get()));
        }
        if (filter instanceof IsNull) {
            IsNull f = (IsNull)filter;
            return Optional.of(String.format("%s IS NULL", f.attribute()));
        }
        if (filter instanceof IsNotNull) {
            IsNotNull f = (IsNotNull)filter;
            return Optional.of(String.format("%s IS NOT NULL", f.attribute()));
        }
        if (filter instanceof Not) {
            Not f = (Not)filter;
            Optional<String> child = FilterPushDown.compileFilter(f.child());
            if (child.isEmpty()) {
                return child;
            }
            return Optional.of(String.format("NOT (%s)", child.get()));
        }
        if (filter instanceof In) {
            In in = (In)filter;
            String values = Arrays.stream(in.values()).map(FilterPushDown::compileValue).collect(Collectors.joining(","));
            return Optional.of(String.format("%s IN (%s)", in.attribute(), values));
        }
        return Optional.empty();
    }

    private static String compileValue(Object value) {
        if (value instanceof String || value instanceof Timestamp || value instanceof Date) {
            return "'" + value + "'";
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            StringBuilder sb = new StringBuilder();
            for (Object obj : array) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(FilterPushDown.compileValue(obj));
            }
            return sb.toString();
        }
        return value.toString();
    }
}

