/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.spark.read;

import com.lancedb.lance.spark.LanceConfig;
import com.lancedb.lance.spark.internal.LanceDatasetAdapter;
import com.lancedb.lance.spark.utils.Optional;
import java.util.OptionalLong;
import org.apache.spark.sql.connector.read.Statistics;

public class LanceStatistics
implements Statistics {
    private final Optional<Long> rowNumber;
    private final Optional<Long> dataBytesSize;

    public LanceStatistics(LanceConfig config) {
        this.rowNumber = LanceDatasetAdapter.getDatasetRowCount(config);
        this.dataBytesSize = LanceDatasetAdapter.getDatasetDataSize(config);
    }

    public OptionalLong sizeInBytes() {
        if (this.dataBytesSize.isPresent()) {
            return OptionalLong.of(this.dataBytesSize.get());
        }
        return OptionalLong.empty();
    }

    public OptionalLong numRows() {
        if (this.rowNumber.isPresent()) {
            return OptionalLong.of(this.rowNumber.get());
        }
        return OptionalLong.empty();
    }
}

