/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.LanceArrowColumnVector;

public class FixedSizeListAccessor {
    private final FixedSizeListVector vector;
    private final LanceArrowColumnVector childAccessor;
    private final int listSize;

    public FixedSizeListAccessor(FixedSizeListVector vector) {
        this.vector = vector;
        this.listSize = vector.getListSize();
        FieldVector dataVector = vector.getDataVector();
        this.childAccessor = new LanceArrowColumnVector((ValueVector)dataVector);
    }

    public boolean isNullAt(int rowId) {
        return this.vector.isNull(rowId);
    }

    public int getNullCount() {
        return this.vector.getNullCount();
    }

    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        int start = rowId * this.listSize;
        return new ColumnarArray((ColumnVector)this.childAccessor, start, this.listSize);
    }

    public void close() {
        if (this.childAccessor != null) {
            this.childAccessor.close();
        }
        this.vector.close();
    }
}

