/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.Cache;
import com.landawn.abacus.util.AsyncExecutor;
import com.landawn.abacus.util.ContinuableFuture;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Properties;
import com.landawn.abacus.util.u;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected static final AsyncExecutor asyncExecutor = new AsyncExecutor(N.max((int)64, (int)(IOUtil.CPU_CORES * 8)), N.max((int)128, (int)(IOUtil.CPU_CORES * 16)), 180L, TimeUnit.SECONDS);
    protected final Properties<String, Object> properties = new Properties();
    protected long defaultLiveTime;
    protected long defaultMaxIdleTime;

    protected AbstractCache() {
        this(10800000L, 1800000L);
    }

    protected AbstractCache(long defaultLiveTime, long defaultMaxIdleTime) {
        this.defaultLiveTime = defaultLiveTime;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    @Override
    public u.Optional<V> get(K k) {
        return u.Optional.ofNullable(this.gett(k));
    }

    @Override
    public boolean put(K key, V value) {
        return this.put(key, value, this.defaultLiveTime, this.defaultMaxIdleTime);
    }

    @Override
    public ContinuableFuture<u.Optional<V>> asyncGet(final K k) {
        return asyncExecutor.execute(new Callable<u.Optional<V>>(){

            @Override
            public u.Optional<V> call() throws Exception {
                return AbstractCache.this.get(k);
            }
        });
    }

    @Override
    public ContinuableFuture<V> asyncGett(final K k) {
        return asyncExecutor.execute(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return AbstractCache.this.gett(k);
            }
        });
    }

    @Override
    public ContinuableFuture<Boolean> asyncPut(final K k, final V v) {
        return asyncExecutor.execute((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractCache.this.put(k, v);
            }
        });
    }

    @Override
    public ContinuableFuture<Boolean> asyncPut(final K k, final V v, final long liveTime, final long maxIdleTime) {
        return asyncExecutor.execute((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractCache.this.put(k, v, liveTime, maxIdleTime);
            }
        });
    }

    @Override
    public ContinuableFuture<Void> asyncRemove(final K k) {
        return asyncExecutor.execute((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractCache.this.remove(k);
                return null;
            }
        });
    }

    @Override
    public ContinuableFuture<Boolean> asyncContainsKey(final K k) {
        return asyncExecutor.execute((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AbstractCache.this.containsKey(k);
            }
        });
    }

    @Override
    public Properties<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public <T> T getProperty(String propName) {
        return (T)this.properties.get((Object)propName);
    }

    @Override
    public <T> T setProperty(String propName, Object propValue) {
        return (T)this.properties.put((Object)propName, propValue);
    }

    @Override
    public <T> T removeProperty(String propName) {
        return (T)this.properties.remove((Object)propName);
    }
}

