/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.Cache;
import com.landawn.abacus.cache.DistributedCache;
import com.landawn.abacus.cache.DistributedCacheClient;
import com.landawn.abacus.cache.JRedis;
import com.landawn.abacus.cache.LocalCache;
import com.landawn.abacus.cache.SpyMemcached;
import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.PoolableWrapper;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.Strings;
import com.landawn.abacus.util.TypeAttrParser;

public final class CacheFactory {
    private CacheFactory() {
    }

    public static <K, V> LocalCache<K, V> createLocalCache(int capacity, long evictDelay) {
        return new LocalCache(capacity, evictDelay);
    }

    public static <K, V> LocalCache<K, V> createLocalCache(int capacity, long evictDelay, long defaultLiveTime, long defaultMaxIdleTime) {
        return new LocalCache(capacity, evictDelay, defaultLiveTime, defaultMaxIdleTime);
    }

    public static <K, V> LocalCache<K, V> createLocalCache(long defaultLiveTime, long defaultMaxIdleTime, KeyedObjectPool<K, PoolableWrapper<V>> pool) {
        return new LocalCache<K, V>(defaultLiveTime, defaultMaxIdleTime, pool);
    }

    public static <K, V> DistributedCache<K, V> createDistributedCache(DistributedCacheClient<V> dcc) {
        return new DistributedCache(dcc);
    }

    public static <K, V> DistributedCache<K, V> createDistributedCache(DistributedCacheClient<V> dcc, String keyPrefix) {
        return new DistributedCache(dcc, keyPrefix);
    }

    public static <K, V> DistributedCache<K, V> createDistributedCache(DistributedCacheClient<V> dcc, String keyPrefix, int maxFailedNumForRetry, long retryDelay) {
        return new DistributedCache(dcc, keyPrefix, maxFailedNumForRetry, retryDelay);
    }

    public static <K, V> Cache<K, V> createCache(String provider) {
        TypeAttrParser attrResult = TypeAttrParser.parse((String)provider);
        Object[] parameters = attrResult.getParameters();
        String url = parameters[0];
        String className = attrResult.getClassName();
        Class cls = null;
        if ("Memcached".equalsIgnoreCase(className)) {
            if (parameters.length == 1) {
                return new DistributedCache(new SpyMemcached(url, 1000L));
            }
            if (parameters.length == 2) {
                return new DistributedCache(new SpyMemcached(url, 1000L), (String)parameters[1]);
            }
            if (parameters.length == 3) {
                return new DistributedCache(new SpyMemcached(url, Numbers.toLong((String)parameters[2])), (String)parameters[1]);
            }
            throw new IllegalArgumentException("Unsupported parameters: " + Strings.join((Object[])parameters));
        }
        if ("Redis".equalsIgnoreCase(className)) {
            if (parameters.length == 1) {
                return new DistributedCache(new JRedis(url, 1000L));
            }
            if (parameters.length == 2) {
                return new DistributedCache(new JRedis(url, 1000L), (String)parameters[1]);
            }
            if (parameters.length == 3) {
                return new DistributedCache(new JRedis(url, Numbers.toLong((String)parameters[2])), (String)parameters[1]);
            }
            throw new IllegalArgumentException("Unsupported parameters: " + Strings.join((Object[])parameters));
        }
        cls = ClassUtil.forClass((String)className);
        return (Cache)TypeAttrParser.newInstance((Class)cls, (String)provider, (Object[])new Object[0]);
    }
}

