/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.landawn.abacus.cache.AbstractCache;
import com.landawn.abacus.util.Numbers;
import java.util.Set;

public class CaffeineCache<K, V>
extends AbstractCache<K, V> {
    private final Cache<K, V> cacheImpl;
    private boolean isClosed = false;

    public CaffeineCache(Cache<K, V> cache) {
        this.cacheImpl = cache;
    }

    @Override
    public V gett(K k) {
        this.assertNotClosed();
        return (V)this.cacheImpl.getIfPresent(k);
    }

    @Override
    public boolean put(K k, V v, long liveTime, long maxIdleTime) {
        this.assertNotClosed();
        this.cacheImpl.put(k, v);
        return true;
    }

    @Override
    public void remove(K k) {
        this.assertNotClosed();
        this.cacheImpl.invalidate(k);
    }

    @Override
    public boolean containsKey(K k) {
        this.assertNotClosed();
        return this.get(k).isPresent();
    }

    @Override
    public Set<K> keySet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.assertNotClosed();
        return Numbers.toIntExact((long)this.cacheImpl.estimatedSize());
    }

    @Override
    public void clear() {
        this.assertNotClosed();
        this.cacheImpl.cleanUp();
    }

    @Override
    public synchronized void close() {
        this.assertNotClosed();
        this.clear();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("This object pool has been closed");
        }
    }
}

