/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.AbstractCache;
import com.landawn.abacus.cache.DistributedCacheClient;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Strings;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DistributedCache<K, V>
extends AbstractCache<K, V> {
    protected static final int DEFAULT_MAX_FAILED_NUMBER = 100;
    protected static final long DEFAULT_RETRY_DELAY = 1000L;
    private final DistributedCacheClient<V> dcc;
    private final String keyPrefix;
    private final int maxFailedNumForRetry;
    private final long retryDelay;
    private final AtomicInteger failedCounter = new AtomicInteger();
    private volatile long lastFailedTime = 0L;
    private boolean isClosed = false;

    protected DistributedCache(DistributedCacheClient<V> dcc) {
        this(dcc, Strings.EMPTY_STRING, 100, 1000L);
    }

    protected DistributedCache(DistributedCacheClient<V> dcc, String keyPrefix) {
        this(dcc, keyPrefix, 100, 1000L);
    }

    protected DistributedCache(DistributedCacheClient<V> dcc, String keyPrefix, int maxFailedNumForRetry, long retryDelay) {
        this.keyPrefix = Strings.isEmpty((CharSequence)keyPrefix) ? Strings.EMPTY_STRING : keyPrefix;
        this.dcc = dcc;
        this.maxFailedNumForRetry = maxFailedNumForRetry;
        this.retryDelay = retryDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V gett(K k) {
        this.assertNotClosed();
        if (this.failedCounter.get() > this.maxFailedNumForRetry && System.currentTimeMillis() - this.lastFailedTime < this.retryDelay) {
            return null;
        }
        V result = null;
        boolean isOK = false;
        try {
            result = this.dcc.get(this.generateKey(k));
            isOK = true;
        }
        finally {
            if (isOK) {
                this.failedCounter.set(0);
            } else {
                this.lastFailedTime = System.currentTimeMillis();
                this.failedCounter.incrementAndGet();
            }
        }
        return result;
    }

    @Override
    public boolean put(K k, V v, long liveTime, long maxIdleTime) {
        this.assertNotClosed();
        return this.dcc.set(this.generateKey(k), v, liveTime);
    }

    @Override
    public void remove(K k) {
        this.assertNotClosed();
        this.dcc.delete(this.generateKey(k));
    }

    @Override
    public boolean containsKey(K k) {
        return this.get(k) != null;
    }

    @Override
    public Set<K> keySet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.assertNotClosed();
        this.dcc.flushAll();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.dcc.disconnect();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected String generateKey(K k) {
        return Strings.isEmpty((CharSequence)this.keyPrefix) ? Strings.base64Encode((byte[])N.stringOf(k).getBytes(Charsets.UTF_8)) : this.keyPrefix + Strings.base64Encode((byte[])N.stringOf(k).getBytes(Charsets.UTF_8));
    }

    protected void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("This object pool has been closed");
        }
    }
}

