/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.AbstractDistributedCacheClient;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.util.AddrUtil;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.N;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;

public class JRedis<T>
extends AbstractDistributedCacheClient<T> {
    private static final KryoParser kryoParser = ParserFactory.createKryoParser();
    private final BinaryShardedJedis jedis;

    public JRedis(String serverUrl) {
        this(serverUrl, 1000L);
    }

    public JRedis(String serverUrl, long timeout) {
        super(serverUrl);
        List addressList = AddrUtil.getAddressList((String)serverUrl);
        ArrayList<JedisShardInfo> jedisClusterNodes = new ArrayList<JedisShardInfo>();
        for (InetSocketAddress addr : addressList) {
            jedisClusterNodes.add(new JedisShardInfo(addr.getHostName(), addr.getPort(), (int)timeout));
        }
        this.jedis = new BinaryShardedJedis(jedisClusterNodes);
    }

    @Override
    public T get(String key) {
        return this.decode(this.jedis.get(this.getKeyBytes(key)));
    }

    @Override
    public boolean set(String key, T obj, long liveTime) {
        this.jedis.setex(this.getKeyBytes(key), this.toSeconds(liveTime), this.encode(obj));
        return true;
    }

    @Override
    public boolean delete(String key) {
        this.jedis.del(this.getKeyBytes(key));
        return true;
    }

    @Override
    public long incr(String key) {
        return this.jedis.incr(this.getKeyBytes(key));
    }

    @Override
    public long incr(String key, int deta) {
        return this.jedis.incrBy(this.getKeyBytes(key), (long)deta);
    }

    @Override
    public long decr(String key) {
        return this.jedis.decr(this.getKeyBytes(key));
    }

    @Override
    public long decr(String key, int deta) {
        return this.jedis.decrBy(this.getKeyBytes(key), (long)deta);
    }

    @Override
    public void flushAll() {
        Collection allShards = this.jedis.getAllShards();
        for (Jedis j : allShards) {
            j.flushAll();
        }
    }

    @Override
    public void disconnect() {
        this.jedis.disconnect();
    }

    protected byte[] getKeyBytes(String key) {
        return key.getBytes(Charsets.UTF_8);
    }

    protected byte[] encode(Object obj) {
        return obj == null ? N.EMPTY_BYTE_ARRAY : kryoParser.encode(obj);
    }

    protected T decode(byte[] bytes) {
        return (T)(N.isEmpty((byte[])bytes) ? null : kryoParser.decode(bytes));
    }
}

