/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.AbstractCache;
import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.PoolFactory;
import com.landawn.abacus.pool.Poolable;
import com.landawn.abacus.pool.PoolableWrapper;
import java.util.Set;

public class LocalCache<K, V>
extends AbstractCache<K, V> {
    private final KeyedObjectPool<K, PoolableWrapper<V>> pool;

    public LocalCache(int capacity, long evictDelay) {
        this(capacity, evictDelay, 10800000L, 1800000L);
    }

    public LocalCache(int capacity, long evictDelay, long defaultLiveTime, long defaultMaxIdleTime) {
        super(defaultLiveTime, defaultMaxIdleTime);
        this.pool = PoolFactory.createKeyedObjectPool((int)capacity, (long)evictDelay);
    }

    public LocalCache(long defaultLiveTime, long defaultMaxIdleTime, KeyedObjectPool<K, PoolableWrapper<V>> pool) {
        super(defaultLiveTime, defaultMaxIdleTime);
        this.pool = pool;
    }

    @Override
    public V gett(K key) {
        PoolableWrapper w = (PoolableWrapper)this.pool.get(key);
        return (V)(w == null ? null : w.value());
    }

    @Override
    public boolean put(K key, V value, long liveTime, long maxIdleTime) {
        return this.pool.put(key, (Poolable)PoolableWrapper.of(value, (long)liveTime, (long)maxIdleTime));
    }

    @Override
    public void remove(K key) {
        this.pool.remove(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.pool.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.pool.keySet();
    }

    @Override
    public int size() {
        return this.pool.size();
    }

    @Override
    public void clear() {
        this.pool.clear();
    }

    @Override
    public synchronized void close() {
        this.pool.close();
    }

    @Override
    public boolean isClosed() {
        return this.pool.isClosed();
    }
}

