/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.annotation.SuppressFBWarnings;
import com.landawn.abacus.cache.AbstractCache;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.pool.AbstractPoolable;
import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.PoolFactory;
import com.landawn.abacus.type.ByteBufferType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.AsyncExecutor;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.MoreExecutors;
import com.landawn.abacus.util.N;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.BitSet;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE", "JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
public class OffHeapCache<K, V>
extends AbstractCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(OffHeapCache.class);
    private static final Parser<?, ?> parser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : ParserFactory.createJSONParser();
    private static final int SEGMENT_SIZE = 0x100000;
    private static final int MIN_BLOCK_SIZE = 256;
    private static final int MAX_BLOCK_SIZE = 8192;
    private static final Unsafe UNSAFE;
    private static final int BYTE_ARRAY_BASE;
    private static final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> scheduleFuture;
    private final long _capacityB;
    private final long _startPtr;
    private final Segment[] _segments;
    private final BitSet _segmentBitSet = new BitSet();
    private final Map<Integer, Deque<Segment>> _segmentQueueMap = new ConcurrentHashMap<Integer, Deque<Segment>>();
    private final Deque<Segment> _queue256 = new LinkedList<Segment>();
    private final Deque<Segment> _queue384 = new LinkedList<Segment>();
    private final Deque<Segment> _queue512 = new LinkedList<Segment>();
    private final Deque<Segment> _queue640 = new LinkedList<Segment>();
    private final Deque<Segment> _queue768 = new LinkedList<Segment>();
    private final Deque<Segment> _queue896 = new LinkedList<Segment>();
    private final Deque<Segment> _queue1024 = new LinkedList<Segment>();
    private final Deque<Segment> _queue1280 = new LinkedList<Segment>();
    private final Deque<Segment> _queue1536 = new LinkedList<Segment>();
    private final Deque<Segment> _queue1792 = new LinkedList<Segment>();
    private final Deque<Segment> _queue2048 = new LinkedList<Segment>();
    private final Deque<Segment> _queue2560 = new LinkedList<Segment>();
    private final Deque<Segment> _queue3072 = new LinkedList<Segment>();
    private final Deque<Segment> _queue3584 = new LinkedList<Segment>();
    private final Deque<Segment> _queue4096 = new LinkedList<Segment>();
    private final Deque<Segment> _queue5120 = new LinkedList<Segment>();
    private final Deque<Segment> _queue6144 = new LinkedList<Segment>();
    private final Deque<Segment> _queue7168 = new LinkedList<Segment>();
    private final Deque<Segment> _queue8192 = new LinkedList<Segment>();
    private final AsyncExecutor _asyncExecutor = new AsyncExecutor();
    private final AtomicInteger _activeVacationTaskCount = new AtomicInteger();
    private final KeyedObjectPool<K, Wrapper<V>> _pool;

    public OffHeapCache(int sizeMB) {
        this(sizeMB, 3000L);
    }

    public OffHeapCache(int sizeMB, long evictDelay) {
        this(sizeMB, evictDelay, 10800000L, 1800000L);
    }

    public OffHeapCache(int sizeMB, long evictDelay, long defaultLiveTime, long defaultMaxIdleTime) {
        super(defaultLiveTime, defaultMaxIdleTime);
        this._capacityB = (long)sizeMB * 0x100000L;
        this._startPtr = UNSAFE.allocateMemory(this._capacityB);
        this._segments = new Segment[(int)(this._capacityB / 0x100000L)];
        int len = this._segments.length;
        for (int i = 0; i < len; ++i) {
            this._segments[i] = new Segment(this._startPtr + (long)(i * 0x100000));
        }
        this._pool = PoolFactory.createKeyedObjectPool((int)((int)(this._capacityB / 256L)), (long)evictDelay);
        if (evictDelay > 0L) {
            Runnable evictTask = () -> {
                block2: {
                    try {
                        this.evict();
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block2;
                        logger.warn(ExceptionUtil.getErrorMessage((Throwable)e));
                    }
                }
            };
            this.scheduleFuture = scheduledExecutor.scheduleWithFixedDelay(evictTask, evictDelay, evictDelay, TimeUnit.MILLISECONDS);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.warn("Starting to shutdown task in OffHeapCache");
                try {
                    OffHeapCache.this.close();
                }
                finally {
                    logger.warn("Completed to shutdown task in OffHeapCache");
                }
            }
        });
    }

    @Override
    public V gett(K k) {
        Wrapper w = (Wrapper)this._pool.get(k);
        return w == null ? null : (V)w.read();
    }

    private static void copyFromMemory(long startPtr, byte[] bytes, int destOffset, int len) {
        UNSAFE.copyMemory(null, startPtr, bytes, destOffset, len);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean put(K k, V v, long liveTime, long maxIdleTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvaialbeSegment getAvailableSegment(int size) {
        Deque<Segment> queue = null;
        int blockSize = 0;
        if (size <= 256) {
            queue = this._queue256;
            blockSize = 256;
        } else if (size <= 384) {
            queue = this._queue384;
            blockSize = 384;
        } else if (size <= 512) {
            queue = this._queue512;
            blockSize = 512;
        } else if (size <= 640) {
            queue = this._queue640;
            blockSize = 640;
        } else if (size <= 768) {
            queue = this._queue768;
            blockSize = 768;
        } else if (size <= 896) {
            queue = this._queue896;
            blockSize = 896;
        } else if (size <= 1024) {
            queue = this._queue1024;
            blockSize = 1024;
        } else if (size <= 1280) {
            queue = this._queue1280;
            blockSize = 1280;
        } else if (size <= 1536) {
            queue = this._queue1536;
            blockSize = 1536;
        } else if (size <= 1792) {
            queue = this._queue1792;
            blockSize = 1792;
        } else if (size <= 2048) {
            queue = this._queue2048;
            blockSize = 2048;
        } else if (size <= 2560) {
            queue = this._queue2560;
            blockSize = 2560;
        } else if (size <= 3072) {
            queue = this._queue3072;
            blockSize = 3072;
        } else if (size <= 3584) {
            queue = this._queue3584;
            blockSize = 3584;
        } else if (size <= 4096) {
            queue = this._queue4096;
            blockSize = 4096;
        } else if (size <= 5120) {
            queue = this._queue5120;
            blockSize = 5120;
        } else if (size <= 6144) {
            queue = this._queue6144;
            blockSize = 6144;
        } else if (size <= 7168) {
            queue = this._queue7168;
            blockSize = 7168;
        } else if (size <= 8192) {
            queue = this._queue8192;
            blockSize = 8192;
        } else {
            throw new RuntimeException("Unsupported object size: " + size);
        }
        Segment segment = null;
        int availableBlockIndex = -1;
        Deque<Segment> deque = queue;
        synchronized (deque) {
            Iterator<Segment> iterator = queue.iterator();
            Iterator<Segment> descendingIterator = queue.descendingIterator();
            int half = queue.size() / 2 + 1;
            int cnt = 0;
            while (iterator.hasNext() && half-- > 0) {
                ++cnt;
                segment = iterator.next();
                availableBlockIndex = segment.allocate();
                if (availableBlockIndex >= 0) {
                    if (cnt <= 3) break;
                    iterator.remove();
                    queue.addFirst(segment);
                    break;
                }
                segment = descendingIterator.next();
                availableBlockIndex = segment.allocate();
                if (availableBlockIndex < 0) continue;
                if (cnt <= 3) break;
                descendingIterator.remove();
                queue.addFirst(segment);
                break;
            }
            if (availableBlockIndex < 0) {
                BitSet bitSet = this._segmentBitSet;
                synchronized (bitSet) {
                    int nextSegmentIndex = this._segmentBitSet.nextClearBit(0);
                    if (nextSegmentIndex >= this._segments.length) {
                        return null;
                    }
                    segment = this._segments[nextSegmentIndex];
                    this._segmentBitSet.set(nextSegmentIndex);
                    this._segmentQueueMap.put(nextSegmentIndex, queue);
                    segment.sizeOfBlock = blockSize;
                    queue.addFirst(segment);
                    availableBlockIndex = segment.allocate();
                }
            }
        }
        return new AvaialbeSegment(segment, availableBlockIndex);
    }

    private static void copyToMemory(byte[] srcBytes, int srcOffset, long startPtr, int len) {
        UNSAFE.copyMemory(srcBytes, srcOffset, null, startPtr, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void vacate() {
        if (this._activeVacationTaskCount.get() > 0) {
            return;
        }
        AtomicInteger atomicInteger = this._activeVacationTaskCount;
        synchronized (atomicInteger) {
            if (this._activeVacationTaskCount.get() > 0) {
                return;
            }
            this._activeVacationTaskCount.incrementAndGet();
            this._asyncExecutor.execute(() -> {
                try {
                    this._pool.vacate();
                    this.evict();
                    N.sleep((long)3000L);
                }
                finally {
                    this._activeVacationTaskCount.decrementAndGet();
                }
            });
        }
    }

    @Override
    public void remove(K k) {
        Wrapper w = (Wrapper)this._pool.remove(k);
        if (w != null) {
            w.destroy();
        }
    }

    @Override
    public boolean containsKey(K k) {
        return this._pool.containsKey(k);
    }

    @Override
    public Set<K> keySet() {
        return this._pool.keySet();
    }

    @Override
    public int size() {
        return this._pool.size();
    }

    @Override
    public void clear() {
        this._pool.clear();
    }

    @Override
    public synchronized void close() {
        if (this._pool.isClosed()) {
            return;
        }
        try {
            if (this.scheduleFuture != null) {
                this.scheduleFuture.cancel(true);
            }
        }
        finally {
            try {
                this._pool.close();
            }
            finally {
                UNSAFE.freeMemory(this._startPtr);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._pool.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        int len = this._segments.length;
        for (int i = 0; i < len; ++i) {
            Deque<Segment> queue;
            if (!this._segments[i].blockBitSet.isEmpty() || (queue = this._segmentQueueMap.get(i)) == null) continue;
            Deque<Segment> deque = queue;
            synchronized (deque) {
                if (this._segments[i].blockBitSet.isEmpty()) {
                    BitSet bitSet = this._segmentBitSet;
                    synchronized (bitSet) {
                        queue.remove(this._segments[i]);
                        this._segmentQueueMap.remove(i);
                        this._segmentBitSet.clear(i);
                    }
                }
                continue;
            }
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            ClassUtil.setAccessible((AccessibleObject)f, (boolean)true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize Unsafe", e);
        }
        BYTE_ARRAY_BASE = UNSAFE.arrayBaseOffset(byte[].class);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(IOUtil.CPU_CORES);
        scheduledExecutor = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)executor);
    }

    private static final class Segment {
        private final BitSet blockBitSet = new BitSet();
        private final long startPtr;
        private int sizeOfBlock;

        public Segment(long segmentStartPtr) {
            this.startPtr = segmentStartPtr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int allocate() {
            BitSet bitSet = this.blockBitSet;
            synchronized (bitSet) {
                int result = this.blockBitSet.nextClearBit(0);
                if (result >= 0x100000 / this.sizeOfBlock) {
                    return -1;
                }
                this.blockBitSet.set(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(int blockIndex) {
            BitSet bitSet = this.blockBitSet;
            synchronized (bitSet) {
                this.blockBitSet.clear(blockIndex);
            }
        }
    }

    private static abstract class Wrapper<T>
    extends AbstractPoolable {
        final Type<T> type;
        final int size;

        Wrapper(Type<T> type, long liveTime, long maxIdleTime, int size) {
            super(liveTime, maxIdleTime);
            this.type = type;
            this.size = size;
        }

        abstract T read();
    }

    private static final class AvaialbeSegment {
        final Segment segment;
        final int availableBlockIndex;

        AvaialbeSegment(Segment segment, int availableBlockIndex) {
            this.segment = segment;
            this.availableBlockIndex = availableBlockIndex;
        }

        void release() {
            this.segment.release(this.availableBlockIndex);
        }
    }

    private static final class SWrapper<T>
    extends Wrapper<T> {
        private Segment segment;
        private final long startPtr;

        SWrapper(Type<T> type, long liveTime, long maxIdleTime, int size, Segment segment, long startPtr) {
            super(type, liveTime, maxIdleTime, size);
            this.segment = segment;
            this.startPtr = startPtr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        T read() {
            SWrapper sWrapper = this;
            synchronized (sWrapper) {
                if (this.segment == null) {
                    return null;
                }
                byte[] bytes = new byte[this.size];
                OffHeapCache.copyFromMemory(this.startPtr, bytes, BYTE_ARRAY_BASE, this.size);
                if (this.type.isPrimitiveByteArray()) {
                    return (T)bytes;
                }
                if (this.type.isByteBuffer()) {
                    return (T)ByteBufferType.valueOf((byte[])bytes);
                }
                return (T)parser.deserialize(this.type.clazz(), (InputStream)new ByteArrayInputStream(bytes));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            SWrapper sWrapper = this;
            synchronized (sWrapper) {
                if (this.segment != null) {
                    this.segment.release((int)((this.startPtr - this.segment.startPtr) / (long)this.segment.sizeOfBlock));
                    this.segment = null;
                }
            }
        }
    }

    private static final class MWrapper<T>
    extends Wrapper<T> {
        private List<Map.Entry<Long, Segment>> segments;

        MWrapper(Type<T> type, long liveTime, long maxIdleTime, int size, List<Map.Entry<Long, Segment>> segments) {
            super(type, liveTime, maxIdleTime, size);
            this.segments = segments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        T read() {
            MWrapper mWrapper = this;
            synchronized (mWrapper) {
                List<Map.Entry<Long, Segment>> localSegments = this.segments;
                if (N.isEmpty(localSegments)) {
                    return null;
                }
                byte[] bytes = new byte[this.size];
                int size = this.size;
                int destOffset = BYTE_ARRAY_BASE;
                for (Map.Entry<Long, Segment> entry : localSegments) {
                    long startPtr = entry.getKey();
                    Segment segment = entry.getValue();
                    int sizeToCopy = size > segment.sizeOfBlock ? segment.sizeOfBlock : size;
                    OffHeapCache.copyFromMemory(startPtr, bytes, destOffset, sizeToCopy);
                    destOffset += sizeToCopy;
                    size -= sizeToCopy;
                }
                if (size != 0) {
                    throw new RuntimeException("Unknown error happening when retrieve value. The remaining size is " + size + " after finishing fetch data from all segments");
                }
                if (this.type.isPrimitiveByteArray()) {
                    return (T)(this.segments == null ? null : bytes);
                }
                if (this.type.isByteBuffer()) {
                    return (T)(this.segments == null ? null : ByteBufferType.valueOf((byte[])bytes));
                }
                return (T)(this.segments == null ? null : parser.deserialize(this.type.clazz(), (InputStream)new ByteArrayInputStream(bytes)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            MWrapper mWrapper = this;
            synchronized (mWrapper) {
                if (this.segments != null) {
                    for (Map.Entry<Long, Segment> entry : this.segments) {
                        Segment segment = entry.getValue();
                        segment.release((int)((entry.getKey() - segment.startPtr) / (long)segment.sizeOfBlock));
                    }
                    this.segments = null;
                }
            }
        }
    }
}

