/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.cache;

import com.landawn.abacus.cache.AbstractDistributedCacheClient;
import com.landawn.abacus.cache.KryoTranscoder;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.util.AddrUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.Transcoder;

public class SpyMemcached<T>
extends AbstractDistributedCacheClient<T> {
    static final Logger logger = LoggerFactory.getLogger(SpyMemcached.class);
    private MemcachedClient mc;

    public SpyMemcached(String serverUrl) {
        this(serverUrl, 1000L);
    }

    public SpyMemcached(String serverUrl, final long timeout) {
        super(serverUrl);
        final KryoTranscoder transcoder = ParserFactory.isKryoAvailable() ? new KryoTranscoder() : null;
        DefaultConnectionFactory connFactory = new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return timeout;
            }

            public Transcoder<Object> getDefaultTranscoder() {
                if (transcoder != null) {
                    return transcoder;
                }
                return super.getDefaultTranscoder();
            }
        };
        this.mc = SpyMemcached.createSpyMemcachedClient(serverUrl, (ConnectionFactory)connFactory);
    }

    @Override
    public T get(String key) {
        return (T)this.mc.get(key);
    }

    public Future<T> asyncGet(String key) {
        return this.mc.asyncGet(key);
    }

    @Override
    @SafeVarargs
    public final Map<String, T> getBulk(String ... keys) {
        return this.mc.getBulk(keys);
    }

    @SafeVarargs
    public final Future<Map<String, T>> asyncGetBulk(String ... keys) {
        return this.mc.asyncGetBulk(keys);
    }

    @Override
    public Map<String, T> getBulk(Collection<String> keys) {
        return this.mc.getBulk(keys);
    }

    public Future<Map<String, T>> asyncGetBulk(Collection<String> keys) {
        return this.mc.asyncGetBulk(keys);
    }

    @Override
    public boolean set(String key, T obj, long liveTime) {
        return (Boolean)this.resultOf((Future)this.mc.set(key, this.toSeconds(liveTime), obj));
    }

    public Future<Boolean> asyncSet(String key, T obj, long liveTime) {
        return this.mc.set(key, this.toSeconds(liveTime), obj);
    }

    public boolean add(String key, T obj, long liveTime) {
        return (Boolean)this.resultOf((Future)this.mc.add(key, this.toSeconds(liveTime), obj));
    }

    public Future<Boolean> asyncAdd(String key, T obj, long liveTime) {
        return this.mc.add(key, this.toSeconds(liveTime), obj);
    }

    public boolean replace(String key, T obj, long liveTime) {
        return (Boolean)this.resultOf((Future)this.mc.replace(key, this.toSeconds(liveTime), obj));
    }

    public Future<Boolean> asyncReplace(String key, T obj, long liveTime) {
        return this.mc.replace(key, this.toSeconds(liveTime), obj);
    }

    @Override
    public boolean delete(String key) {
        return (Boolean)this.resultOf((Future)this.mc.delete(key));
    }

    public Future<Boolean> asyncDelete(String key) {
        return this.mc.delete(key);
    }

    @Override
    public long incr(String key) {
        return this.mc.incr(key, 1);
    }

    @Override
    public long incr(String key, int deta) {
        return this.mc.incr(key, deta);
    }

    public long incr(String key, int deta, long defaultValue) {
        return this.mc.incr(key, deta, defaultValue, -1);
    }

    public long incr(String key, int deta, long defaultValue, long liveTime) {
        return this.mc.incr(key, deta, defaultValue, this.toSeconds(liveTime));
    }

    @Override
    public long decr(String key) {
        return this.mc.decr(key, 1);
    }

    @Override
    public long decr(String key, int deta) {
        return this.mc.decr(key, deta);
    }

    public long decr(String key, int deta, long defaultValue) {
        return this.mc.decr(key, deta, defaultValue, -1);
    }

    public long decr(String key, int deta, long defaultValue, long liveTime) {
        return this.mc.decr(key, deta, defaultValue, this.toSeconds(liveTime));
    }

    @Override
    public void flushAll() {
        this.resultOf((Future)this.mc.flush());
    }

    public Future<Boolean> asyncFlushAll() {
        return this.mc.flush();
    }

    public boolean flushAll(long delay) {
        return (Boolean)this.resultOf((Future)this.mc.flush(this.toSeconds(delay)));
    }

    public Future<Boolean> asyncFlushAll(long delay) {
        return this.mc.flush(this.toSeconds(delay));
    }

    @Override
    public void disconnect() {
        this.mc.shutdown();
    }

    public void disconnect(long timeout) {
        this.mc.shutdown(timeout, TimeUnit.MICROSECONDS);
    }

    protected <R> R resultOf(Future<R> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw N.toRuntimeException((Exception)e);
        }
    }

    protected static MemcachedClient createSpyMemcachedClient(String serverUrl, ConnectionFactory connFactory) throws UncheckedIOException {
        try {
            return new MemcachedClient(connFactory, AddrUtil.getAddressList((String)serverUrl));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Memcached client.", e);
        }
    }
}

