/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.cache.SpyMemcached;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.N;

public final class MemcachedLock<K, V> {
    static final Logger logger = LoggerFactory.getLogger(MemcachedLock.class);
    private final SpyMemcached<V> mc;

    public MemcachedLock(String serverUrl) {
        this.mc = new SpyMemcached(serverUrl);
    }

    public boolean lock(K target, long liveTime) {
        return this.lock(target, N.EMPTY_BYTE_ARRAY, liveTime);
    }

    public boolean lock(K target, V value, long liveTime) {
        String key = this.toKey(target);
        try {
            return this.mc.add(key, value, liveTime);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lock target with key: " + key, e);
        }
    }

    public boolean isLocked(K target) {
        return this.mc.get(this.toKey(target)) != null;
    }

    public V get(K target) {
        V value = this.mc.get(this.toKey(target));
        return (V)(value instanceof byte[] && ((byte[])value).length == 0 ? null : value);
    }

    public boolean unlock(K target) {
        try {
            return this.mc.delete(this.toKey(target));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unlock with key: " + target, e);
        }
    }

    protected String toKey(K target) {
        return N.stringOf(target);
    }

    public SpyMemcached<V> client() {
        return this.mc;
    }
}

