/*
 * Copyright (C) 2015 HaiYang Li
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.landawn.abacus.type;

import org.joda.time.DateTime;

import com.landawn.abacus.util.N;

/**
 *
 * @author Haiyang Li
 * @since 0.8
 */
public class JodaDateTimeType extends AbstractJodaDateTimeType<DateTime> {

    public static final String JODA_DATE_TIME = "JodaDateTime";

    JodaDateTimeType() {
        super(JODA_DATE_TIME);
    }

    JodaDateTimeType(String typeName) {
        super(typeName);
    }

    @Override
    public Class<DateTime> clazz() {
        return DateTime.class;
    }

    /**
     *
     * @param str
     * @return
     */
    @Override
    public DateTime valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }

        if (N.equals(str, SYS_TIME)) {
            return new DateTime(System.currentTimeMillis());
        }

        return str.length() == 20 ? iso8601DateTimeFT.parseDateTime(str) : iso8601TimestampFT.parseDateTime(str);
    }

    /**
     *
     * @param cbuf
     * @param offset
     * @param len
     * @return
     */
    @Override
    public DateTime valueOf(char[] cbuf, int offset, int len) {
        if ((cbuf == null) || (len == 0)) {
            return null;
        }

        if (cbuf[offset + 4] != '-') {
            try {
                return new DateTime(parseLong(cbuf, offset, len));
            } catch (NumberFormatException e) {
                // ignore;
            }
        }

        return valueOf(String.valueOf(cbuf, offset, len));
    }
}
