/*
 * Copyright (c) 2016, Haiyang Li. All rights reserved.
 */

package com.landawn.abacus.type;

import java.io.IOException;
import java.io.Writer;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.MutableFloat;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;

/**
 *
 * @author Haiyang Li
 * @since 0.8
 */
public class MutableFloatType extends MutableType<MutableFloat> {

    public static final String MUTABLE_FLOAT = MutableFloat.class.getSimpleName();

    protected MutableFloatType() {
        super(MUTABLE_FLOAT);
    }

    @Override
    public Class<MutableFloat> clazz() {
        return MutableFloat.class;
    }

    /**
     *
     * @param x
     * @return
     */
    @Override
    public String stringOf(MutableFloat x) {
        return x == null ? null : N.stringOf(x.floatValue());
    }

    /**
     *
     * @param str
     * @return
     */
    @Override
    public MutableFloat valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : MutableFloat.of(Numbers.toFloat(str));
    }

    /**
     *
     * @param writer
     * @param x
     * @throws IOException Signals that an I/O exception has occurred.
     */
    @Override
    public void write(Writer writer, MutableFloat x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.floatValue());
        }
    }

    /**
     *
     * @param writer
     * @param x
     * @param config
     * @throws IOException Signals that an I/O exception has occurred.
     */
    @Override
    public void writeCharacter(CharacterWriter writer, MutableFloat x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.floatValue());
        }
    }
}
