/*
 * Copyright (C) 2015 HaiYang Li
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.landawn.abacus.type;

import java.net.URI;

import com.landawn.abacus.util.N;

/**
 *
 * @author Haiyang Li
 * @since 0.8
 */
public class URIType extends AbstractType<URI> {

    public static final String URI = URI.class.getSimpleName();

    URIType() {
        super(URI);
    }

    @Override
    public Class<URI> clazz() {
        return URI.class;
    }

    /**
     *
     * @param x
     * @return
     */
    @Override
    public String stringOf(URI x) {
        return (x == null) ? null : x.toString();
    }

    /**
     *
     * @param str
     * @return
     */
    @Override
    public URI valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }

        return java.net.URI.create(str);
    }
}
