/*
 * Copyright (C) 2015 HaiYang Li
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.landawn.abacus.type;

import java.util.List;
import java.util.Map;

import com.landawn.abacus.util.WD;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ClassUtil;

/**
 *
 * @author Haiyang Li
 * @param <T>
 * @since 0.8
 */
public class XMLType<T> extends AbstractType<T> {

    public static final String XML = "XML";

    private final String declaringName;

    private final Class<T> typeClass;
    //    private final Type<T>[] parameterTypes;
    //    private final Type<T> elementType;

    @SuppressWarnings("unchecked")
    XMLType(String clsName) {
        super(XML + WD.LESS_THAN + TypeFactory.getType(clsName).name() + WD.GREATER_THAN);

        this.declaringName = XML + WD.LESS_THAN + TypeFactory.getType(clsName).declaringName() + WD.GREATER_THAN;
        this.typeClass = (Class<T>) ("Map".equalsIgnoreCase(clsName) ? Map.class
                : ("List".equalsIgnoreCase(clsName) ? List.class : ClassUtil.forClass(clsName)));
        //        this.parameterTypes = new Type[] { TypeFactory.getType(clsName) };
        //        this.elementType = parameterTypes[0];
    }

    @Override
    public String declaringName() {
        return declaringName;
    }

    @Override
    public Class<T> clazz() {
        return typeClass;
    }

    //    @Override
    //    public Type<T> getElementType() {
    //        return elementType;
    //    }
    //
    //    @Override
    //    public Type<T>[] getParameterTypes() {
    //        return parameterTypes;
    //    }
    //
    //    @Override
    //    public boolean isGenericType() {
    //        return true;
    //    }

    /**
     *
     * @param x
     * @return
     */
    @Override
    public String stringOf(T x) {
        return (x == null) ? null : Utils.xmlParser.serialize(x);
    }

    /**
     *
     * @param str
     * @return
     */
    @Override
    public T valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : Utils.xmlParser.deserialize(typeClass, str);
    }
}
