/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import java.util.ArrayList;
import java.util.List;

public class Between
extends AbstractCondition {
    private static final long serialVersionUID = 486757046031623324L;
    final String propName;
    private Object minValue;
    private Object maxValue;

    Between() {
        this.propName = null;
    }

    public Between(String propName, Object minValue, Object maxValue) {
        super(Operator.BETWEEN);
        if (N.isNullOrEmpty(propName)) {
            throw new IllegalArgumentException("property name can't be null or empty.");
        }
        this.propName = propName;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getPropName() {
        return this.propName;
    }

    public <T> T getMinValue() {
        return (T)this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public <T> T getMaxValue() {
        return (T)this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.minValue != null && this.minValue instanceof Condition) {
            parameters.addAll(((Condition)this.minValue).getParameters());
        } else {
            parameters.add(this.minValue);
        }
        if (this.maxValue != null && this.maxValue instanceof Condition) {
            parameters.addAll(((Condition)this.maxValue).getParameters());
        } else {
            parameters.add(this.maxValue);
        }
        return parameters;
    }

    @Override
    public void clearParameters() {
        if (this.minValue != null && this.minValue instanceof Condition) {
            ((Condition)this.minValue).getParameters().clear();
        } else {
            this.minValue = null;
        }
        if (this.maxValue != null && this.maxValue instanceof Condition) {
            ((Condition)this.maxValue).getParameters().clear();
        } else {
            this.maxValue = null;
        }
    }

    @Override
    public <T extends Condition> T copy() {
        Between copy = (Between)super.copy();
        if (this.minValue != null && this.minValue instanceof Condition) {
            copy.minValue = ((Condition)this.minValue).copy();
        }
        if (this.minValue != null && this.maxValue instanceof Condition) {
            copy.maxValue = ((Condition)this.maxValue).copy();
        }
        return (T)copy;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        if (namingPolicy == NamingPolicy.NO_CHANGE) {
            return this.propName + ' ' + this.getOperator().toString() + " (" + Between.parameter2String(this.minValue, namingPolicy) + ", " + Between.parameter2String(this.maxValue, namingPolicy) + ')';
        }
        return namingPolicy.convert(this.propName) + ' ' + this.getOperator().toString() + " (" + Between.parameter2String(this.minValue, namingPolicy) + ", " + Between.parameter2String(this.maxValue, namingPolicy) + ')';
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.propName.hashCode();
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + (this.minValue == null ? 0 : this.minValue.hashCode());
        h = h * 31 + (this.maxValue == null ? 0 : this.maxValue.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Between) {
            Between other = (Between)obj;
            return N.equals(this.propName, other.propName) && N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.minValue, other.minValue) && N.equals(this.maxValue, other.maxValue);
        }
        return false;
    }
}

