/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import java.util.List;

public class Binary
extends AbstractCondition {
    private static final long serialVersionUID = 1552347171930293343L;
    final String propName;
    private Object propValue;

    Binary() {
        this.propName = null;
    }

    public Binary(String propName, Operator operator, Object propValue) {
        super(operator);
        if (N.isNullOrEmpty(propName)) {
            throw new IllegalArgumentException("property name can't be null or empty.");
        }
        this.propName = propName;
        this.propValue = propValue;
    }

    public String getPropName() {
        return this.propName;
    }

    public <T> T getPropValue() {
        return (T)this.propValue;
    }

    public void setPropValue(Object propValue) {
        this.propValue = propValue;
    }

    @Override
    public List<Object> getParameters() {
        if (this.propValue != null && this.propValue instanceof Condition) {
            return ((Condition)this.propValue).getParameters();
        }
        return N.asList(this.propValue);
    }

    @Override
    public void clearParameters() {
        if (this.propValue != null && this.propValue instanceof Condition) {
            ((Condition)this.propValue).clearParameters();
        } else {
            this.propValue = null;
        }
    }

    @Override
    public <T extends Condition> T copy() {
        Binary copy = (Binary)super.copy();
        if (this.propValue != null && this.propValue instanceof Condition) {
            copy.propValue = ((Condition)this.propValue).copy();
        }
        return (T)copy;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        if (namingPolicy == NamingPolicy.NO_CHANGE) {
            return this.propName + ' ' + this.getOperator().toString() + ' ' + Binary.parameter2String(this.propValue, namingPolicy);
        }
        return namingPolicy.convert(this.propName) + ' ' + this.getOperator().toString() + ' ' + Binary.parameter2String(this.propValue, namingPolicy);
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.propName.hashCode();
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + (this.propValue == null ? 0 : this.propValue.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary other = (Binary)obj;
            return N.equals(this.propName, other.propName) && N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.propValue, other.propValue);
        }
        return false;
    }
}

