/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.condition.All;
import com.landawn.abacus.condition.And;
import com.landawn.abacus.condition.Any;
import com.landawn.abacus.condition.Between;
import com.landawn.abacus.condition.Binary;
import com.landawn.abacus.condition.Cell;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Criteria;
import com.landawn.abacus.condition.CrossJoin;
import com.landawn.abacus.condition.Equal;
import com.landawn.abacus.condition.Except;
import com.landawn.abacus.condition.Exists;
import com.landawn.abacus.condition.Expression;
import com.landawn.abacus.condition.FullJoin;
import com.landawn.abacus.condition.GreaterEqual;
import com.landawn.abacus.condition.GreaterThan;
import com.landawn.abacus.condition.GroupBy;
import com.landawn.abacus.condition.Having;
import com.landawn.abacus.condition.In;
import com.landawn.abacus.condition.InSubQuery;
import com.landawn.abacus.condition.InnerJoin;
import com.landawn.abacus.condition.Intersect;
import com.landawn.abacus.condition.Is;
import com.landawn.abacus.condition.IsInfinite;
import com.landawn.abacus.condition.IsNaN;
import com.landawn.abacus.condition.IsNot;
import com.landawn.abacus.condition.IsNotInfinite;
import com.landawn.abacus.condition.IsNotNaN;
import com.landawn.abacus.condition.IsNotNull;
import com.landawn.abacus.condition.IsNull;
import com.landawn.abacus.condition.Join;
import com.landawn.abacus.condition.Junction;
import com.landawn.abacus.condition.LeftJoin;
import com.landawn.abacus.condition.LessEqual;
import com.landawn.abacus.condition.LessThan;
import com.landawn.abacus.condition.Like;
import com.landawn.abacus.condition.Limit;
import com.landawn.abacus.condition.Minus;
import com.landawn.abacus.condition.NamedProperty;
import com.landawn.abacus.condition.NaturalJoin;
import com.landawn.abacus.condition.Not;
import com.landawn.abacus.condition.NotEqual;
import com.landawn.abacus.condition.NotIn;
import com.landawn.abacus.condition.NotInSubQuery;
import com.landawn.abacus.condition.On;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.condition.Or;
import com.landawn.abacus.condition.OrderBy;
import com.landawn.abacus.condition.RightJoin;
import com.landawn.abacus.condition.Some;
import com.landawn.abacus.condition.SubQuery;
import com.landawn.abacus.condition.Union;
import com.landawn.abacus.condition.UnionAll;
import com.landawn.abacus.condition.Using;
import com.landawn.abacus.condition.Where;
import com.landawn.abacus.condition.XOR;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.SQLBuilder;
import com.landawn.abacus.util.SortDirection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionFactory {
    public static final Expression QME = Expression.Expr.of("?");
    public static final SortDirection ASC = SortDirection.ASC;
    public static final SortDirection DESC = SortDirection.DESC;
    private static final Expression ALWAYS_TRUE = Expression.of("1 < 2");
    private static final Expression ALWAYS_FALSE = Expression.of("1 > 2");

    private ConditionFactory() {
    }

    public static Expression alwaysTrue() {
        return ALWAYS_TRUE;
    }

    @Deprecated
    public static Expression alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static NamedProperty namedProperty(String propName) {
        return NamedProperty.of(propName);
    }

    public static Expression expr(String literal) {
        return Expression.of(literal);
    }

    public static Binary binary(String propName, Operator operator, Object propValue) {
        return new Binary(propName, operator, propValue);
    }

    public static Equal equal(String propName, Object propValue) {
        return new Equal(propName, propValue);
    }

    public static Equal equal(String propName) {
        return ConditionFactory.equal(propName, QME);
    }

    public static Equal eq(String propName, Object propValue) {
        return new Equal(propName, propValue);
    }

    public static Equal eq(String propName) {
        return ConditionFactory.eq(propName, QME);
    }

    @SafeVarargs
    public static Or eqOr(String propName, Object ... propValues) {
        N.checkArgNotNullOrEmpty(propValues, "propValues");
        Or or = CF.or(new Condition[0]);
        for (Object propValue : propValues) {
            or.add(ConditionFactory.eq(propName, propValue));
        }
        return or;
    }

    public static Or eqOr(String propName, Collection<?> propValues) {
        N.checkArgNotNullOrEmpty(propValues, "propValues");
        Or or = CF.or(new Condition[0]);
        for (Object propValue : propValues) {
            or.add(ConditionFactory.eq(propName, propValue));
        }
        return or;
    }

    public static Or eqOr(Map<String, ?> props) {
        N.checkArgNotNullOrEmpty(props, "props");
        Set<String> selectPropNames = props.keySet();
        Iterator iter = selectPropNames.iterator();
        if (selectPropNames.size() == 1) {
            String propName = (String)iter.next();
            return ConditionFactory.or(ConditionFactory.eq(propName, props.get(propName)));
        }
        if (selectPropNames.size() == 2) {
            String propName1 = (String)iter.next();
            String propName2 = (String)iter.next();
            return ConditionFactory.eq(propName1, props.get(propName1)).or(ConditionFactory.eq(propName2, props.get(propName2)));
        }
        Condition[] conds = new Condition[selectPropNames.size()];
        String propName = null;
        int size = selectPropNames.size();
        for (int i = 0; i < size; ++i) {
            propName = (String)iter.next();
            conds[i] = CF.eq(propName, props.get(propName));
        }
        return ConditionFactory.or(conds);
    }

    public static Or eqOr(Object entity) {
        return ConditionFactory.eqOr(entity, SQLBuilder.getSelectPropNames(entity.getClass(), false, null));
    }

    public static Or eqOr(Object entity, Collection<String> selectPropNames) {
        N.checkArgNotNullOrEmpty(selectPropNames, "selectPropNames");
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entity.getClass());
        Iterator<String> iter = selectPropNames.iterator();
        if (selectPropNames.size() == 1) {
            String propName = iter.next();
            return ConditionFactory.or(ConditionFactory.eq(propName, entityInfo.getPropValue(entity, propName)));
        }
        if (selectPropNames.size() == 2) {
            String propName1 = iter.next();
            String propName2 = iter.next();
            return ConditionFactory.eq(propName1, entityInfo.getPropValue(entity, propName1)).or(ConditionFactory.eq(propName2, entityInfo.getPropValue(entity, propName2)));
        }
        Condition[] conds = new Condition[selectPropNames.size()];
        String propName = null;
        int size = selectPropNames.size();
        for (int i = 0; i < size; ++i) {
            propName = iter.next();
            conds[i] = CF.eq(propName, entityInfo.getPropValue(entity, propName));
        }
        return ConditionFactory.or(conds);
    }

    public static Or eqOr(String propName1, Object propValue1, String propName2, Object propValue2) {
        return ConditionFactory.eq(propName1, propValue1).or(ConditionFactory.eq(propName2, propValue2));
    }

    public static Or eqOr(String propName1, Object propValue1, String propName2, Object propValue2, String propName3, Object propValue3) {
        return ConditionFactory.or(ConditionFactory.eq(propName1, propValue1), ConditionFactory.eq(propName2, propValue2), ConditionFactory.eq(propName3, propValue3));
    }

    public static And eqAnd(Map<String, ?> props) {
        N.checkArgNotNullOrEmpty(props, "props");
        Set<String> selectPropNames = props.keySet();
        Iterator iter = selectPropNames.iterator();
        if (selectPropNames.size() == 1) {
            String propName = (String)iter.next();
            return ConditionFactory.and(ConditionFactory.eq(propName, props.get(propName)));
        }
        if (selectPropNames.size() == 2) {
            String propName1 = (String)iter.next();
            String propName2 = (String)iter.next();
            return ConditionFactory.eq(propName1, props.get(propName1)).and(ConditionFactory.eq(propName2, props.get(propName2)));
        }
        Condition[] conds = new Condition[selectPropNames.size()];
        String propName = null;
        int size = selectPropNames.size();
        for (int i = 0; i < size; ++i) {
            propName = (String)iter.next();
            conds[i] = CF.eq(propName, props.get(propName));
        }
        return ConditionFactory.and(conds);
    }

    public static And eqAnd(Object entity) {
        return ConditionFactory.eqAnd(entity, SQLBuilder.getSelectPropNames(entity.getClass(), false, null));
    }

    public static And eqAnd(Object entity, Collection<String> selectPropNames) {
        N.checkArgNotNullOrEmpty(selectPropNames, "selectPropNames");
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entity.getClass());
        Iterator<String> iter = selectPropNames.iterator();
        if (selectPropNames.size() == 1) {
            String propName = iter.next();
            return ConditionFactory.and(ConditionFactory.eq(propName, entityInfo.getPropValue(entity, propName)));
        }
        if (selectPropNames.size() == 2) {
            String propName1 = iter.next();
            String propName2 = iter.next();
            return ConditionFactory.eq(propName1, entityInfo.getPropValue(entity, propName1)).and(ConditionFactory.eq(propName2, entityInfo.getPropValue(entity, propName2)));
        }
        Condition[] conds = new Condition[selectPropNames.size()];
        String propName = null;
        int size = selectPropNames.size();
        for (int i = 0; i < size; ++i) {
            propName = iter.next();
            conds[i] = CF.eq(propName, entityInfo.getPropValue(entity, propName));
        }
        return ConditionFactory.and(conds);
    }

    public static And eqAnd(String propName1, Object propValue1, String propName2, Object propValue2) {
        return ConditionFactory.eq(propName1, propValue1).and(ConditionFactory.eq(propName2, propValue2));
    }

    public static And eqAnd(String propName1, Object propValue1, String propName2, Object propValue2, String propName3, Object propValue3) {
        return ConditionFactory.and(ConditionFactory.eq(propName1, propValue1), ConditionFactory.eq(propName2, propValue2), ConditionFactory.eq(propName3, propValue3));
    }

    @Beta
    public static Or eqAndOr(List<? extends Map<String, ?>> propsList) {
        N.checkArgNotNullOrEmpty(propsList, "propsList");
        Condition[] conds = new Condition[propsList.size()];
        int size = propsList.size();
        for (int i = 0; i < size; ++i) {
            conds[i] = ConditionFactory.eqAnd(propsList.get(i));
        }
        return ConditionFactory.or(conds);
    }

    @Beta
    public static Or eqAndOr(Collection<?> entities) {
        N.checkArgNotNullOrEmpty(entities, "entities");
        return ConditionFactory.eqAndOr(entities, SQLBuilder.getSelectPropNames(N.firstNonNull(entities).orNull().getClass(), false, null));
    }

    @Beta
    public static Or eqAndOr(Collection<?> entities, Collection<String> selectPropNames) {
        N.checkArgNotNullOrEmpty(entities, "entities");
        N.checkArgNotNullOrEmpty(selectPropNames, "selectPropNames");
        Iterator<?> iter = entities.iterator();
        Condition[] conds = new Condition[entities.size()];
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            conds[i] = ConditionFactory.eqAnd(iter.next(), selectPropNames);
        }
        return ConditionFactory.or(conds);
    }

    public static And gtAndLt(String propName, Object minValue, Object maxValue) {
        return ConditionFactory.gt(propName, minValue).and(ConditionFactory.lt(propName, maxValue));
    }

    public static And gtAndLt(String propName) {
        return ConditionFactory.gt(propName).and(ConditionFactory.lt(propName));
    }

    public static And geAndLt(String propName, Object minValue, Object maxValue) {
        return ConditionFactory.ge(propName, minValue).and(ConditionFactory.lt(propName, maxValue));
    }

    public static And geAndLt(String propName) {
        return ConditionFactory.ge(propName).and(ConditionFactory.lt(propName));
    }

    public static And geAndLe(String propName, Object minValue, Object maxValue) {
        return ConditionFactory.ge(propName, minValue).and(ConditionFactory.le(propName, maxValue));
    }

    public static And geAndLe(String propName) {
        return ConditionFactory.ge(propName).and(ConditionFactory.le(propName));
    }

    public static And gtAndLe(String propName, Object minValue, Object maxValue) {
        return ConditionFactory.gt(propName, minValue).and(ConditionFactory.le(propName, maxValue));
    }

    public static And gtAndLe(String propName) {
        return ConditionFactory.gt(propName).and(ConditionFactory.le(propName));
    }

    public static NotEqual notEqual(String propName, Object propValue) {
        return new NotEqual(propName, propValue);
    }

    public static NotEqual notEqual(String propName) {
        return ConditionFactory.notEqual(propName, QME);
    }

    public static NotEqual ne(String propName, Object propValue) {
        return new NotEqual(propName, propValue);
    }

    public static NotEqual ne(String propName) {
        return ConditionFactory.ne(propName, QME);
    }

    public static GreaterThan greaterThan(String propName, Object propValue) {
        return new GreaterThan(propName, propValue);
    }

    public static GreaterThan greaterThan(String propName) {
        return ConditionFactory.greaterThan(propName, QME);
    }

    public static GreaterThan gt(String propName, Object propValue) {
        return new GreaterThan(propName, propValue);
    }

    public static GreaterThan gt(String propName) {
        return ConditionFactory.gt(propName, QME);
    }

    public static GreaterEqual greaterEqual(String propName, Object propValue) {
        return new GreaterEqual(propName, propValue);
    }

    public static GreaterEqual greaterEqual(String propName) {
        return ConditionFactory.greaterEqual(propName, QME);
    }

    public static GreaterEqual ge(String propName, Object propValue) {
        return new GreaterEqual(propName, propValue);
    }

    public static GreaterEqual ge(String propName) {
        return ConditionFactory.ge(propName, QME);
    }

    public static LessThan lessThan(String propName, Object propValue) {
        return new LessThan(propName, propValue);
    }

    public static LessThan lessThan(String propName) {
        return ConditionFactory.lessThan(propName, QME);
    }

    public static LessThan lt(String propName, Object propValue) {
        return new LessThan(propName, propValue);
    }

    public static LessThan lt(String propName) {
        return ConditionFactory.lt(propName, QME);
    }

    public static LessEqual lessEqual(String propName, Object propValue) {
        return new LessEqual(propName, propValue);
    }

    public static LessEqual lessEqual(String propName) {
        return ConditionFactory.lessEqual(propName, QME);
    }

    public static LessEqual le(String propName, Object propValue) {
        return new LessEqual(propName, propValue);
    }

    public static LessEqual le(String propName) {
        return ConditionFactory.le(propName, QME);
    }

    public static Between between(String propName, Object minValue, Object maxValue) {
        return new Between(propName, minValue, maxValue);
    }

    public static Between between(String propName) {
        return new Between(propName, CF.QME, CF.QME);
    }

    public static Between bt(String propName, Object minValue, Object maxValue) {
        return new Between(propName, minValue, maxValue);
    }

    public static Between bt(String propName) {
        return new Between(propName, CF.QME, CF.QME);
    }

    public static Like like(String propName, Object propValue) {
        return new Like(propName, propValue);
    }

    public static Like like(String propName) {
        return ConditionFactory.like(propName, QME);
    }

    public static Not notLike(String propName, Object propValue) {
        return ConditionFactory.like(propName, propValue).not();
    }

    public static Not notLike(String propName) {
        return ConditionFactory.notLike(propName, QME);
    }

    public static Like contains(String propName, Object propValue) {
        return new Like(propName, '%' + N.stringOf(propValue) + '%');
    }

    public static Like startsWith(String propName, Object propValue) {
        return new Like(propName, N.stringOf(propValue) + '%');
    }

    public static Like endsWith(String propName, Object propValue) {
        return new Like(propName, '%' + N.stringOf(propValue));
    }

    public static IsNull isNull(String propName) {
        return new IsNull(propName);
    }

    public static IsNotNull isNotNull(String propName) {
        return new IsNotNull(propName);
    }

    public static IsNaN isNaN(String propName) {
        return new IsNaN(propName);
    }

    public static IsNotNaN isNotNaN(String propName) {
        return new IsNotNaN(propName);
    }

    public static IsInfinite isInfinite(String propName) {
        return new IsInfinite(propName);
    }

    public static IsNotInfinite isNotInfinite(String propName) {
        return new IsNotInfinite(propName);
    }

    public static Is is(String propName, Object propValue) {
        return new Is(propName, propValue);
    }

    public static IsNot isNot(String propName, Object propValue) {
        return new IsNot(propName, propValue);
    }

    public static XOR xor(String propName, Object propValue) {
        return new XOR(propName, propValue);
    }

    @SafeVarargs
    public static Or or(Condition ... conditions) {
        return new Or(conditions);
    }

    public static Or or(Collection<? extends Condition> conditions) {
        return new Or(conditions);
    }

    @SafeVarargs
    public static And and(Condition ... conditions) {
        return new And(conditions);
    }

    public static And and(Collection<? extends Condition> conditions) {
        return new And(conditions);
    }

    @SafeVarargs
    public static Junction junction(Operator operator, Condition ... conditions) {
        return new Junction(operator, conditions);
    }

    public static Junction junction(Operator operator, Collection<? extends Condition> conditions) {
        return new Junction(operator, conditions);
    }

    public static Where where(Condition condition) {
        return new Where(condition);
    }

    public static Where where(String condition) {
        return new Where(ConditionFactory.expr(condition));
    }

    @SafeVarargs
    public static GroupBy groupBy(String ... propNames) {
        return new GroupBy(propNames);
    }

    public static GroupBy groupBy(Collection<String> propNames) {
        return ConditionFactory.groupBy(propNames, SortDirection.ASC);
    }

    public static GroupBy groupBy(Collection<String> propNames, SortDirection direction) {
        return new GroupBy(propNames, direction);
    }

    public static GroupBy groupBy(String propName, SortDirection direction) {
        return new GroupBy(propName, direction);
    }

    public static GroupBy groupBy(String propNameA, SortDirection directionA, String propNameB, SortDirection directionB) {
        return ConditionFactory.groupBy(N.asLinkedHashMap(propNameA, directionA, propNameB, directionB));
    }

    public static GroupBy groupBy(String propNameA, SortDirection directionA, String propNameB, SortDirection directionB, String propNameC, SortDirection directionC) {
        return ConditionFactory.groupBy(N.asLinkedHashMap(propNameA, directionA, propNameB, directionB, propNameC, directionC));
    }

    public static GroupBy groupBy(Map<String, SortDirection> orders) {
        return new GroupBy(orders);
    }

    public static GroupBy groupBy(LinkedHashMap<String, SortDirection> orders) {
        return new GroupBy(orders);
    }

    public static GroupBy groupBy(Condition condition) {
        return new GroupBy(condition);
    }

    public static Having having(Condition condition) {
        return new Having(condition);
    }

    public static Having having(String condition) {
        return new Having(ConditionFactory.expr(condition));
    }

    @SafeVarargs
    public static OrderBy orderBy(String ... propNames) {
        return new OrderBy(propNames);
    }

    @SafeVarargs
    public static OrderBy orderByAsc(String ... propNames) {
        return new OrderBy(Array.asList(propNames), SortDirection.ASC);
    }

    @SafeVarargs
    public static OrderBy orderByDesc(String ... propNames) {
        return new OrderBy(Array.asList(propNames), SortDirection.DESC);
    }

    public static OrderBy orderBy(Collection<String> propNames) {
        return ConditionFactory.orderBy(propNames, SortDirection.ASC);
    }

    public static OrderBy orderBy(Collection<String> propNames, SortDirection direction) {
        return new OrderBy(propNames, direction);
    }

    public static OrderBy orderBy(String propName, SortDirection direction) {
        return new OrderBy(propName, direction);
    }

    public static OrderBy orderBy(String propNameA, SortDirection directionA, String propNameB, SortDirection directionB) {
        return ConditionFactory.orderBy(N.asLinkedHashMap(propNameA, directionA, propNameB, directionB));
    }

    public static OrderBy orderBy(String propNameA, SortDirection directionA, String propNameB, SortDirection directionB, String propNameC, SortDirection directionC) {
        return ConditionFactory.orderBy(N.asLinkedHashMap(propNameA, directionA, propNameB, directionB, propNameC, directionC));
    }

    public static OrderBy orderBy(Map<String, SortDirection> orders) {
        return new OrderBy(orders);
    }

    public static OrderBy orderBy(LinkedHashMap<String, SortDirection> orders) {
        return new OrderBy(orders);
    }

    public static OrderBy orderBy(Condition condition) {
        return new OrderBy(condition);
    }

    public static On on(Condition condition) {
        return new On(condition);
    }

    public static On on(String condition) {
        return new On(ConditionFactory.expr(condition));
    }

    public static On on(String propName, String anoPropName) {
        return new On(propName, anoPropName);
    }

    public static On on(Map<String, String> propNamePair) {
        return new On(propNamePair);
    }

    @Deprecated
    @SafeVarargs
    public static Using using(String ... columnNames) {
        return new Using(columnNames);
    }

    @Deprecated
    public static Using using(Collection<String> columnNames) {
        return new Using(columnNames);
    }

    public static Join join(String joinEntity) {
        return new Join(joinEntity);
    }

    public static Join join(String joinEntity, Condition condition) {
        return new Join(joinEntity, condition);
    }

    public static Join join(Collection<String> joinEntities, Condition condition) {
        return new Join(joinEntities, condition);
    }

    public static LeftJoin leftJoin(String joinEntity) {
        return new LeftJoin(joinEntity);
    }

    public static LeftJoin leftJoin(String joinEntity, Condition condition) {
        return new LeftJoin(joinEntity, condition);
    }

    public static LeftJoin leftJoin(Collection<String> joinEntities, Condition condition) {
        return new LeftJoin(joinEntities, condition);
    }

    public static RightJoin rightJoin(String joinEntity) {
        return new RightJoin(joinEntity);
    }

    public static RightJoin rightJoin(String joinEntity, Condition condition) {
        return new RightJoin(joinEntity, condition);
    }

    public static RightJoin rightJoin(Collection<String> joinEntities, Condition condition) {
        return new RightJoin(joinEntities, condition);
    }

    public static CrossJoin crossJoin(String joinEntity) {
        return new CrossJoin(joinEntity);
    }

    public static CrossJoin crossJoin(String joinEntity, Condition condition) {
        return new CrossJoin(joinEntity, condition);
    }

    public static CrossJoin crossJoin(Collection<String> joinEntities, Condition condition) {
        return new CrossJoin(joinEntities, condition);
    }

    public static FullJoin fullJoin(String joinEntity) {
        return new FullJoin(joinEntity);
    }

    public static FullJoin fullJoin(String joinEntity, Condition condition) {
        return new FullJoin(joinEntity, condition);
    }

    public static FullJoin fullJoin(Collection<String> joinEntities, Condition condition) {
        return new FullJoin(joinEntities, condition);
    }

    public static InnerJoin innerJoin(String joinEntity) {
        return new InnerJoin(joinEntity);
    }

    public static InnerJoin innerJoin(String joinEntity, Condition condition) {
        return new InnerJoin(joinEntity, condition);
    }

    public static InnerJoin innerJoin(Collection<String> joinEntities, Condition condition) {
        return new InnerJoin(joinEntities, condition);
    }

    public static NaturalJoin naturalJoin(String joinEntity) {
        return new NaturalJoin(joinEntity);
    }

    public static NaturalJoin naturalJoin(String joinEntity, Condition condition) {
        return new NaturalJoin(joinEntity, condition);
    }

    public static NaturalJoin naturalJoin(Collection<String> joinEntities, Condition condition) {
        return new NaturalJoin(joinEntities, condition);
    }

    public static In in(String propName, int[] values) {
        return ConditionFactory.in(propName, (Object[])Array.box(values));
    }

    public static In in(String propName, long[] values) {
        return ConditionFactory.in(propName, (Object[])Array.box(values));
    }

    public static In in(String propName, double[] values) {
        return ConditionFactory.in(propName, (Object[])Array.box(values));
    }

    public static In in(String propName, Object[] values) {
        return ConditionFactory.in(propName, Arrays.asList(values));
    }

    public static In in(String propName, Collection<?> values) {
        return new In(propName, values);
    }

    public static InSubQuery in(String propName, SubQuery subQuery) {
        return new InSubQuery(propName, subQuery);
    }

    public static InSubQuery in(Collection<String> propNames, SubQuery subQuery) {
        return new InSubQuery(propNames, subQuery);
    }

    public static NotIn notIn(String propName, int[] values) {
        return ConditionFactory.notIn(propName, (Object[])Array.box(values));
    }

    public static NotIn notIn(String propName, long[] values) {
        return ConditionFactory.notIn(propName, (Object[])Array.box(values));
    }

    public static NotIn notIn(String propName, double[] values) {
        return ConditionFactory.notIn(propName, (Object[])Array.box(values));
    }

    public static NotIn notIn(String propName, Object[] values) {
        return ConditionFactory.notIn(propName, Arrays.asList(values));
    }

    public static NotIn notIn(String propName, Collection<?> values) {
        return new NotIn(propName, values);
    }

    public static NotInSubQuery notIn(String propName, SubQuery subQuery) {
        return new NotInSubQuery(propName, subQuery);
    }

    public static NotInSubQuery notIn(Collection<String> propNames, SubQuery subQuery) {
        return new NotInSubQuery(propNames, subQuery);
    }

    public static All all(SubQuery condition) {
        return new All(condition);
    }

    public static Any any(SubQuery condition) {
        return new Any(condition);
    }

    public static Some some(SubQuery condition) {
        return new Some(condition);
    }

    public static Exists exists(SubQuery condition) {
        return new Exists(condition);
    }

    public static Not notExists(SubQuery condition) {
        return ConditionFactory.exists(condition).not();
    }

    public static Union union(SubQuery condition) {
        return new Union(condition);
    }

    public static UnionAll unionAll(SubQuery condition) {
        return new UnionAll(condition);
    }

    public static Except except(SubQuery condition) {
        return new Except(condition);
    }

    public static Intersect intersect(SubQuery condition) {
        return new Intersect(condition);
    }

    public static Minus minus(SubQuery condition) {
        return new Minus(condition);
    }

    public static Cell cell(Operator operator, Condition condition) {
        return new Cell(operator, condition);
    }

    public static SubQuery subQuery(Class<?> entityClass, Collection<String> propNames, Condition condition) {
        return new SubQuery(entityClass, propNames, condition);
    }

    public static SubQuery subQuery(String entityName, Collection<String> propNames, Condition condition) {
        return new SubQuery(entityName, propNames, condition);
    }

    public static SubQuery subQuery(String entityName, Collection<String> propNames, String condition) {
        return new SubQuery(entityName, propNames, (Condition)ConditionFactory.expr(condition));
    }

    public static SubQuery subQuery(String entityName, String sql) {
        return new SubQuery(entityName, sql);
    }

    public static Limit limit(int count) {
        return new Limit(count);
    }

    public static Limit limit(int offset, int count) {
        return new Limit(offset, count);
    }

    public static Limit limit(String expr) {
        return new Limit(expr);
    }

    public static Criteria criteria() {
        return new Criteria();
    }

    public static final class CB {
        private CB() {
        }

        public static Criteria where(Condition condition) {
            return CF.criteria().where(condition);
        }

        public static Criteria where(String condition) {
            return CF.criteria().where(condition);
        }

        public static Criteria groupBy(Condition condition) {
            return CF.criteria().groupBy(condition);
        }

        @SafeVarargs
        public static final Criteria groupBy(String ... propNames) {
            return CF.criteria().groupBy(propNames);
        }

        public static Criteria groupBy(String propName, SortDirection direction) {
            return CF.criteria().groupBy(propName, direction);
        }

        public static Criteria groupBy(Collection<String> propNames) {
            return CF.criteria().groupBy(propNames);
        }

        public static Criteria groupBy(Collection<String> propNames, SortDirection direction) {
            return CF.criteria().groupBy(propNames, direction);
        }

        public static Criteria groupBy(Map<String, SortDirection> orders) {
            return CF.criteria().groupBy(orders);
        }

        public static Criteria having(Condition condition) {
            return CF.criteria().having(condition);
        }

        public static Criteria having(String condition) {
            return CF.criteria().having(condition);
        }

        public static Criteria orderBy(Condition condition) {
            return CF.criteria().orderBy(condition);
        }

        @SafeVarargs
        public static final Criteria orderBy(String ... propNames) {
            return CF.criteria().orderBy(propNames);
        }

        public static Criteria orderBy(String propName, SortDirection direction) {
            return CF.criteria().orderBy(propName, direction);
        }

        public static Criteria orderBy(Collection<String> propNames) {
            return CF.criteria().orderBy(propNames);
        }

        public static Criteria orderBy(Collection<String> propNames, SortDirection direction) {
            return CF.criteria().orderBy(propNames, direction);
        }

        public static Criteria orderBy(Map<String, SortDirection> orders) {
            return CF.criteria().orderBy(orders);
        }

        public static Criteria limit(Limit condition) {
            return CF.criteria().limit(condition);
        }

        public static Criteria limit(int count) {
            return CF.criteria().limit(count);
        }

        public static Criteria limit(int offset, int count) {
            return CF.criteria().limit(offset, count);
        }

        public static Criteria limit(String expr) {
            return CF.criteria().limit(expr);
        }
    }

    public static final class CF
    extends ConditionFactory {
        private CF() {
        }
    }
}

