/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Cell;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.ConditionFactory;
import com.landawn.abacus.condition.CriteriaUtil;
import com.landawn.abacus.condition.Except;
import com.landawn.abacus.condition.GroupBy;
import com.landawn.abacus.condition.Having;
import com.landawn.abacus.condition.Intersect;
import com.landawn.abacus.condition.Join;
import com.landawn.abacus.condition.Limit;
import com.landawn.abacus.condition.Minus;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.condition.OrderBy;
import com.landawn.abacus.condition.SubQuery;
import com.landawn.abacus.condition.Union;
import com.landawn.abacus.condition.UnionAll;
import com.landawn.abacus.condition.Where;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.SortDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Criteria
extends AbstractCondition {
    private static final long serialVersionUID = 7534336752211519239L;
    private static final Set<Operator> aggregationOperators = N.newHashSet();
    private boolean distinct = false;
    private List<Condition> conditionList = new ArrayList<Condition>();

    public Criteria() {
        super(Operator.EMPTY);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<Join> getJoins() {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (Condition cond : this.conditionList) {
            if (!(cond instanceof Join)) continue;
            joins.add((Join)cond);
        }
        return joins;
    }

    public Cell getWhere() {
        return (Cell)this.find(Operator.WHERE);
    }

    public Cell getGroupBy() {
        return (Cell)this.find(Operator.GROUP_BY);
    }

    public Cell getHaving() {
        return (Cell)this.find(Operator.HAVING);
    }

    public List<Cell> getAggregation() {
        List<Cell> result = null;
        for (Condition cond : this.conditionList) {
            if (!aggregationOperators.contains((Object)cond.getOperator())) continue;
            if (result == null) {
                result = new ArrayList<Cell>();
            }
            result.add((Cell)cond);
        }
        if (result == null) {
            result = N.emptyList();
        }
        return result;
    }

    public Cell getOrderBy() {
        return (Cell)this.find(Operator.ORDER_BY);
    }

    public Limit getLimit() {
        return (Limit)this.find(Operator.LIMIT);
    }

    public List<Condition> getConditions() {
        return this.conditionList;
    }

    public List<Condition> get(Operator operator) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (Condition cond : this.conditionList) {
            if (!cond.getOperator().equals((Object)operator)) continue;
            conditions.add(cond);
        }
        return conditions;
    }

    void add(Condition ... conditions) {
        this.addConditions(conditions);
    }

    void add(Collection<? extends Condition> conditions) {
        this.addConditions(conditions);
    }

    void remove(Operator operator) {
        List<Condition> conditions = this.get(operator);
        this.remove(conditions);
    }

    void remove(Condition ... conditions) {
        for (Condition cond : conditions) {
            this.conditionList.remove(cond);
        }
    }

    void remove(Collection<? extends Condition> conditions) {
        this.conditionList.removeAll(conditions);
    }

    public void clear() {
        this.conditionList.clear();
    }

    @Override
    public List<Object> getParameters() {
        if (this.conditionList.size() > 0) {
            Cell having;
            ArrayList<Object> parameters = new ArrayList<Object>();
            List<Join> joins = this.getJoins();
            for (Join join : joins) {
                parameters.addAll(join.getParameters());
            }
            Cell where = this.getWhere();
            if (where != null) {
                parameters.addAll(where.getParameters());
            }
            if ((having = this.getHaving()) != null) {
                parameters.addAll(having.getParameters());
            }
            List<Cell> conditionList = this.getAggregation();
            for (Condition condition : conditionList) {
                parameters.addAll(condition.getParameters());
            }
            return parameters;
        }
        return N.emptyList();
    }

    @Override
    public void clearParameters() {
        for (Condition condition : this.conditionList) {
            condition.clearParameters();
        }
    }

    public Criteria distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @SafeVarargs
    public final Criteria join(Join ... joins) {
        this.add(joins);
        return this;
    }

    public Criteria join(Collection<Join> joins) {
        this.add(joins);
        return this;
    }

    public Criteria join(String joinEntity) {
        this.add(new Join(joinEntity));
        return this;
    }

    public Criteria join(String joinEntity, Condition condition) {
        this.add(new Join(joinEntity, condition));
        return this;
    }

    public Criteria join(Collection<String> joinEntities, Condition condition) {
        this.add(new Join(joinEntities, condition));
        return this;
    }

    public Criteria where(Condition condition) {
        if (condition.getOperator().equals((Object)Operator.WHERE)) {
            this.add(condition);
        } else {
            this.add(new Where(condition));
        }
        return this;
    }

    public Criteria where(String condition) {
        this.add(new Where(ConditionFactory.CF.expr(condition)));
        return this;
    }

    public Criteria groupBy(Condition condition) {
        if (condition.getOperator().equals((Object)Operator.GROUP_BY)) {
            this.add(condition);
        } else {
            this.add(new GroupBy(condition));
        }
        return this;
    }

    @SafeVarargs
    public final Criteria groupBy(String ... propNames) {
        this.add(new GroupBy(propNames));
        return this;
    }

    public Criteria groupBy(String propName, SortDirection direction) {
        this.add(new GroupBy(propName, direction));
        return this;
    }

    public Criteria groupBy(Collection<String> propNames) {
        return this.groupBy(propNames, SortDirection.ASC);
    }

    public Criteria groupBy(Collection<String> propNames, SortDirection direction) {
        this.add(new GroupBy(propNames, direction));
        return this;
    }

    public Criteria groupBy(Map<String, SortDirection> orders) {
        this.add(new GroupBy(orders));
        return this;
    }

    public Criteria having(Condition condition) {
        if (condition.getOperator().equals((Object)Operator.HAVING)) {
            this.add(condition);
        } else {
            this.add(new Having(condition));
        }
        return this;
    }

    public Criteria having(String condition) {
        this.add(new Having(ConditionFactory.CF.expr(condition)));
        return this;
    }

    public Criteria orderBy(Condition condition) {
        if (condition.getOperator().equals((Object)Operator.ORDER_BY)) {
            this.add(condition);
        } else {
            this.add(new OrderBy(condition));
        }
        return this;
    }

    @SafeVarargs
    public final Criteria orderBy(String ... propNames) {
        this.add(new OrderBy(propNames));
        return this;
    }

    public Criteria orderBy(String propName, SortDirection direction) {
        this.add(new OrderBy(propName, direction));
        return this;
    }

    public Criteria orderBy(Collection<String> propNames) {
        return this.orderBy(propNames, SortDirection.ASC);
    }

    public Criteria orderBy(Collection<String> propNames, SortDirection direction) {
        this.add(new OrderBy(propNames, direction));
        return this;
    }

    public Criteria orderBy(Map<String, SortDirection> orders) {
        this.add(new OrderBy(orders));
        return this;
    }

    public Criteria limit(Limit condition) {
        this.add(condition);
        return this;
    }

    public Criteria limit(int count) {
        this.add(ConditionFactory.CF.limit(count));
        return this;
    }

    public Criteria limit(int offset, int count) {
        this.add(ConditionFactory.CF.limit(offset, count));
        return this;
    }

    public Criteria limit(String expr) {
        this.add(ConditionFactory.CF.limit(expr));
        return this;
    }

    public Criteria union(SubQuery subQuery) {
        this.add(new Union(subQuery));
        return this;
    }

    public Criteria unionAll(SubQuery subQuery) {
        this.add(new UnionAll(subQuery));
        return this;
    }

    public Criteria intersect(SubQuery subQuery) {
        this.add(new Intersect(subQuery));
        return this;
    }

    public Criteria except(SubQuery subQuery) {
        this.add(new Except(subQuery));
        return this;
    }

    public Criteria minus(SubQuery subQuery) {
        this.add(new Minus(subQuery));
        return this;
    }

    @Override
    public <T extends Condition> T copy() {
        Criteria result = (Criteria)super.copy();
        result.conditionList = new ArrayList<Condition>();
        for (Condition cond : this.conditionList) {
            result.conditionList.add((Condition)cond.copy());
        }
        return (T)result;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        String distinct = this.isDistinct() ? " DISTINCT" : N.EMPTY_STRING;
        String join = N.EMPTY_STRING;
        String where = N.EMPTY_STRING;
        String groupBy = N.EMPTY_STRING;
        String having = N.EMPTY_STRING;
        String orderBy = N.EMPTY_STRING;
        String limit = N.EMPTY_STRING;
        String forUpdate = N.EMPTY_STRING;
        String aggregate = N.EMPTY_STRING;
        for (Condition cond : this.conditionList) {
            if (Operator.WHERE.equals((Object)cond.getOperator())) {
                where = where + ' ' + cond.toString(namingPolicy);
                continue;
            }
            if (Operator.ORDER_BY.equals((Object)cond.getOperator())) {
                orderBy = orderBy + ' ' + cond.toString(namingPolicy);
                continue;
            }
            if (Operator.GROUP_BY.equals((Object)cond.getOperator())) {
                groupBy = groupBy + ' ' + cond.toString(namingPolicy);
                continue;
            }
            if (Operator.HAVING.equals((Object)cond.getOperator())) {
                having = having + ' ' + cond.toString(namingPolicy);
                continue;
            }
            if (Operator.LIMIT.equals((Object)cond.getOperator())) {
                limit = limit + ' ' + cond.toString(namingPolicy);
                continue;
            }
            if (cond instanceof Join) {
                join = join + ' ' + cond.toString(namingPolicy);
                continue;
            }
            aggregate = aggregate + ' ' + cond.toString(namingPolicy);
        }
        return distinct + join + where + groupBy + having + aggregate + orderBy + limit + forUpdate;
    }

    public int hashCode() {
        int h = this.isDistinct() ? 17 : 31;
        h = h * 31 + this.conditionList.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Criteria && N.equals(((Criteria)obj).distinct, this.distinct) && N.equals(((Criteria)obj).conditionList, this.conditionList);
    }

    private void checkConditions(Collection<? extends Condition> conditions) {
        for (Condition condition : conditions) {
            this.checkCondition(condition);
        }
    }

    private void checkConditions(Condition ... conditions) {
        for (Condition cond : conditions) {
            this.checkCondition(cond);
        }
    }

    private void checkCondition(Condition cond) {
        if (!CriteriaUtil.isClause(cond.getOperator())) {
            throw new IllegalArgumentException("Criteria only accepts condition: " + CriteriaUtil.getClauseOperators() + ". Doesn't accept[" + (Object)((Object)cond.getOperator()) + "]. ");
        }
    }

    private void addConditions(Collection<? extends Condition> conditions) {
        this.checkConditions(conditions);
        for (Condition condition : conditions) {
            this.addCondition(condition);
        }
    }

    private void addConditions(Condition ... conditions) {
        this.checkConditions(conditions);
        for (Condition cond : conditions) {
            this.addCondition(cond);
        }
    }

    private void addCondition(Condition cond) {
        Condition cell;
        if ((Operator.WHERE.equals((Object)cond.getOperator()) || Operator.ORDER_BY.equals((Object)cond.getOperator()) || Operator.GROUP_BY.equals((Object)cond.getOperator()) || Operator.HAVING.equals((Object)cond.getOperator()) || Operator.LIMIT.equals((Object)cond.getOperator())) && (cell = this.find(cond.getOperator())) != null) {
            this.conditionList.remove(cell);
        }
        this.conditionList.add(cond);
    }

    private Condition find(Operator operator) {
        Condition cond = null;
        for (int i = 0; i < this.conditionList.size(); ++i) {
            cond = this.conditionList.get(i);
            if (!cond.getOperator().equals((Object)operator)) continue;
            return cond;
        }
        return null;
    }

    static {
        aggregationOperators.add(Operator.UNION_ALL);
        aggregationOperators.add(Operator.UNION);
        aggregationOperators.add(Operator.INTERSECT);
        aggregationOperators.add(Operator.EXCEPT);
        aggregationOperators.add(Operator.MINUS);
    }
}

