/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Criteria;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Set;

@Internal
public final class CriteriaUtil {
    private static final ImmutableSet<Operator> clauseOperators;

    private CriteriaUtil() {
    }

    public static Set<Operator> getClauseOperators() {
        return clauseOperators;
    }

    public static boolean isClause(Operator operator) {
        return operator == null ? false : clauseOperators.contains((Object)operator);
    }

    public static boolean isClause(String operator) {
        return CriteriaUtil.isClause(Operator.getOperator(operator));
    }

    public static boolean isClause(Condition condition) {
        return condition == null ? false : CriteriaUtil.isClause(condition.getOperator());
    }

    @SafeVarargs
    public static void add(Criteria criteria, Condition ... conditions) {
        criteria.add(conditions);
    }

    public static void add(Criteria criteria, Collection<Condition> conditions) {
        criteria.add(conditions);
    }

    public static void remove(Criteria criteria, Operator operator) {
        criteria.remove(operator);
    }

    @SafeVarargs
    public static void remove(Criteria criteria, Condition ... conditions) {
        criteria.remove(conditions);
    }

    public static void remove(Criteria criteria, Collection<Condition> conditions) {
        criteria.remove(conditions);
    }

    static {
        Set set = N.newLinkedHashSet();
        set.add(Operator.JOIN);
        set.add(Operator.LEFT_JOIN);
        set.add(Operator.RIGHT_JOIN);
        set.add(Operator.FULL_JOIN);
        set.add(Operator.CROSS_JOIN);
        set.add(Operator.INNER_JOIN);
        set.add(Operator.NATURAL_JOIN);
        set.add(Operator.WHERE);
        set.add(Operator.GROUP_BY);
        set.add(Operator.HAVING);
        set.add(Operator.ORDER_BY);
        set.add(Operator.LIMIT);
        set.add(Operator.UNION_ALL);
        set.add(Operator.UNION);
        set.add(Operator.INTERSECT);
        set.add(Operator.EXCEPT);
        set.add(Operator.MINUS);
        clauseOperators = ImmutableSet.of(set);
    }
}

