/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Join
extends AbstractCondition {
    private static final long serialVersionUID = -6241397386906482856L;
    private List<String> joinEntities;
    private Condition condition;

    Join() {
    }

    public Join(String joinEntity) {
        this(Operator.JOIN, joinEntity);
    }

    protected Join(Operator operator, String joinEntity) {
        this(operator, joinEntity, null);
    }

    public Join(String joinEntity, Condition condition) {
        this(Operator.JOIN, joinEntity, condition);
    }

    protected Join(Operator operator, String joinEntity, Condition condition) {
        this(operator, Array.asList(joinEntity), condition);
    }

    public Join(Collection<String> joinEntities, Condition condition) {
        this(Operator.JOIN, joinEntities, condition);
    }

    protected Join(Operator operator, Collection<String> joinEntities, Condition condition) {
        super(operator);
        this.joinEntities = new ArrayList<String>(joinEntities);
        this.condition = condition;
    }

    public List<String> getJoinEntities() {
        return this.joinEntities;
    }

    public <T extends Condition> T getCondition() {
        return (T)this.condition;
    }

    @Override
    public List<Object> getParameters() {
        return this.condition == null ? N.emptyList() : this.condition.getParameters();
    }

    @Override
    public void clearParameters() {
        if (this.condition != null) {
            this.condition.clearParameters();
        }
    }

    @Override
    public <T extends Condition> T copy() {
        Join copy = (Join)super.copy();
        if (this.joinEntities != null) {
            copy.joinEntities = new ArrayList<String>(this.joinEntities);
        }
        if (this.condition != null) {
            copy.condition = this.condition.copy();
        }
        return (T)copy;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        return this.getOperator().toString() + ' ' + Join.concatPropNames(this.joinEntities) + (this.condition == null ? N.EMPTY_STRING : ' ' + this.getCondition().toString(namingPolicy));
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + this.joinEntities.hashCode();
        if (this.condition != null) {
            h = h * 31 + this.condition.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Join) {
            Join other = (Join)obj;
            return N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.joinEntities, other.joinEntities) && N.equals(this.condition, other.condition);
        }
        return false;
    }
}

