/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Junction
extends AbstractCondition {
    private static final long serialVersionUID = -5520467185002717755L;
    List<Condition> conditionList;

    Junction() {
    }

    @SafeVarargs
    public Junction(Operator operator, Condition ... conditions) {
        super(operator);
        this.conditionList = new ArrayList<Condition>();
        this.add(conditions);
    }

    public Junction(Operator operator, Collection<? extends Condition> conditions) {
        super(operator);
        this.conditionList = new ArrayList<Condition>();
        this.add(conditions);
    }

    public List<Condition> getConditions() {
        return this.conditionList;
    }

    @SafeVarargs
    public final void set(Condition ... conditions) {
        this.conditionList.clear();
        this.add(conditions);
    }

    public void set(Collection<? extends Condition> conditions) {
        this.conditionList.clear();
        this.add(conditions);
    }

    @SafeVarargs
    public final void add(Condition ... conditions) {
        for (Condition cond : conditions) {
            this.conditionList.add(cond);
        }
    }

    public void add(Collection<? extends Condition> conditions) {
        this.conditionList.addAll(conditions);
    }

    @SafeVarargs
    public final void remove(Condition ... conditions) {
        for (Condition cond : conditions) {
            this.conditionList.remove(cond);
        }
    }

    public void remove(Collection<? extends Condition> conditions) {
        this.conditionList.removeAll(conditions);
    }

    public void clear() {
        this.conditionList.clear();
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (Condition condition : this.conditionList) {
            parameters.addAll(condition.getParameters());
        }
        return parameters;
    }

    @Override
    public void clearParameters() {
        for (Condition condition : this.conditionList) {
            condition.clearParameters();
        }
    }

    @Override
    public <T extends Condition> T copy() {
        Junction result = (Junction)super.copy();
        result.conditionList = new ArrayList<Condition>();
        for (Condition cond : this.conditionList) {
            result.conditionList.add((Condition)cond.copy());
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(NamingPolicy namingPolicy) {
        if (N.isNullOrEmpty(this.conditionList)) {
            return N.EMPTY_STRING;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        try {
            sb.append('(');
            for (int i = 0; i < this.conditionList.size(); ++i) {
                if (i > 0) {
                    sb.append(' ');
                    sb.append(this.getOperator().toString());
                    sb.append(' ');
                }
                sb.append('(');
                sb.append(this.conditionList.get(i).toString(namingPolicy));
                sb.append(')');
            }
            sb.append(')');
            String string = sb.toString();
            return string;
        }
        finally {
            Objectory.recycle(sb);
        }
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + this.conditionList.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Junction) {
            Junction other = (Junction)obj;
            return N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.conditionList, other.conditionList);
        }
        return false;
    }
}

